/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css1.CssFontCSS2;
import org.w3c.css.properties.css1.CssFontConstantCSS2;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssFontSizeCSS2
extends CssProperty
implements CssFontConstantCSS2 {
    int value;
    CssValue cssValue;
    private static int[] hash_values = new int[FONTSIZE.length];

    public CssFontSizeCSS2() {
        this.value = 3;
    }

    public CssFontSizeCSS2(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        if (val instanceof CssIdent) {
            int hash = val.hashCode();
            for (int i = 0; i < hash_values.length; ++i) {
                if (hash_values[i] != hash) continue;
                this.value = i;
                this.cssValue = null;
                expression.next();
                return;
            }
        } else {
            if (val instanceof CssPercentage) {
                float num = ((Float)val.get()).floatValue();
                if (num < 0.0f) {
                    throw new InvalidParamException("negative-value", val.toString(), ac);
                }
                this.cssValue = val;
                expression.next();
                return;
            }
            if (val instanceof CssNumber) {
                CssLength length = ((CssNumber)val).getLength();
                if (length != null) {
                    this.cssValue = length;
                    expression.next();
                    return;
                }
            } else if (val instanceof CssLength) {
                float f = ((Float)val.get()).floatValue();
                if (f >= 0.0f) {
                    this.cssValue = val;
                    expression.next();
                    return;
                }
                throw new InvalidParamException("negative-value", val.toString(), ac);
            }
        }
        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
    }

    public CssFontSizeCSS2(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        if (this.cssValue != null) {
            return this.cssValue;
        }
        return FONTSIZE[this.value];
    }

    public boolean isSoftlyInherited() {
        return this.value == FONTSIZE.length - 1;
    }

    public String toString() {
        if (this.cssValue != null) {
            return this.cssValue.toString();
        }
        return FONTSIZE[this.value];
    }

    public String getPropertyName() {
        return "font-size";
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        CssFontCSS2 cssFont = ((Css1Style)style).cssFontCSS2;
        if (cssFont.fontSize != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssFont.fontSize = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getFontSizeCSS2();
        }
        return ((Css1Style)style).cssFontCSS2.fontSize;
    }

    public boolean equals(CssProperty property) {
        if (this.cssValue == null) {
            return property instanceof CssFontSizeCSS2 && ((CssFontSizeCSS2)property).value == this.value;
        }
        return property instanceof CssFontSizeCSS2 && ((CssFontSizeCSS2)property).cssValue.equals(this.cssValue);
    }

    static {
        for (int i = 0; i < FONTSIZE.length; ++i) {
            CssFontSizeCSS2.hash_values[i] = FONTSIZE[i].hashCode();
        }
    }
}

