/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FakeFile {
    protected String fileName;
    protected byte[] data;
    protected int count;

    public FakeFile(String fileName) {
        this.fileName = fileName;
        this.data = new byte[255];
    }

    public String getName() {
        return this.fileName;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.count > 0) {
            this.trimToSize();
            return new ByteArrayInputStream(this.data);
        }
        return null;
    }

    public synchronized int getSize() {
        return this.count;
    }

    public final synchronized void trimToSize() {
        int oldCapacity = this.data.length;
        if (this.count < oldCapacity) {
            byte[] oldData = this.data;
            this.data = new byte[this.count];
            System.arraycopy(oldData, 0, this.data, 0, this.count);
        }
    }

    private final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            byte[] oldData = this.data;
            this.data = new byte[minCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.count);
        }
    }

    public void write(byte[] data, int start, int len) {
        if (len <= 0) {
            return;
        }
        this.ensureCapacity(this.count + len);
        for (int i = 0; i < len; ++i) {
            this.data[this.count + i] = data[i + start];
        }
        this.count += len;
    }
}

