#include <jerq.h>
#define INIT_TICKS 5
#define MAX_ANGLE 3

int tracking = 1, visible = 1, turning = 0;
int angle = 0, ticks_per_change, nticks;
int cangle, sangle, dangle;
Point Center;
int xmin,xxmax,ymin,yymax;
int oldangle = 0; Point oldcenter;

main(){
	request(MOUSE);
	initial();
	for(;; sleep(2)){
		if(P->state & RESHAPED) {
			initial();
			P->state &= ~RESHAPED;
			}
		wait(MOUSE);
		if(button2()) {  domenu(); continue; }
		if((!tracking) || (!visible)) continue;
		if(!ptinrect(mouse.xy,Drect)) continue;
		drawline();	/* erase current line */
		if(button13()){
			if(!turning++) {
				ticks_per_change = INIT_TICKS;
				dangle = 1;
				nticks = -1;
				}
			else nticks --;
			if(nticks<0){	/* update angle */
				angle += button1()?dangle:-dangle;
				if(angle>360) angle -=360;
				if(angle<0) angle +=360;
				cangle = cos(angle); sangle = sin(angle);
				nticks = ticks_per_change;
				if(ticks_per_change > 0) ticks_per_change -= 1;
				else if(dangle<MAX_ANGLE) dangle++;
				}
			}
		else turning = 0;
		Center = mouse.xy;
		drawline();	/* draw new line */
		}
}

drawline()
{
	int d,dist1,dist2,dx1,dx2,dy1,dy2,px,py;
	if(cangle>0) { dx1 = xxmax-Center.x; dx2 = Center.x-xmin; }
	else {dx2 = -(xxmax-Center.x); dx1 = xmin-Center.x; }
	if(sangle>0) {dy1 = Center.y-ymin; dy2 = yymax-Center.y; }
	else {dy2 = ymin-Center.y; dy1 = -(yymax-Center.y); }
	dist1 = 20000;
	if(cangle!=0) {d = muldiv(dx1,1024,cangle); dist1 = (d<dist1)|(dist1<0)?d:dist1;}
	if(sangle!=0) {d = muldiv(dy1,1024,sangle); dist1 = (d<dist1)|(dist1<0)?d:dist1;}
	dist2 = 20000;
	if(cangle!=0) {d = muldiv(dx2,1024,cangle); dist2 = (d<dist2)|(dist2<0)?d:dist2;}
	if(sangle!=0) {d = muldiv(dy2,1024,sangle); dist2 = (d<dist2)|(dist2<0)?d:dist2;}
	segment(
		&display,
		add(Center,Pt(muldiv(dist1,cangle,1024),-muldiv(dist1,sangle,1024))),
		add(Center,Pt(-muldiv(dist2,cangle,1024),muldiv(dist2,sangle,1024))),
		F_XOR
		);
}

char *items[] = {"Track","Visible","Horizontal","Vertical",
	"Remember","Restore","Deposit","Pause","Exit",NULL};
Menu menu = { items };


Texture skull ={
	0x0000, 0x0000, 0x0000, 0xC003, 0xE7E7, 0x3FFC, 0x0FF0, 0x0DB0,
	0x07E0, 0x0660, 0x37EC, 0xE427, 0xC3C3, 0x0000, 0x0000, 0x0000
	};
Texture shademap ={
	0x1000, 0, 0, 0, 0, 0, 0, 0,
	0x0000, 0, 0, 0, 0, 0, 0, 0,
	};


domenu()
{
	items[1] = visible?"Invisible":"Visible";
	switch(menuhit( &menu, 2)){
	case 0:	/* Track */
		if(!visible) drawline();
		visible = tracking = 1;
		break;
	case 1:	/* Visible/Invisible */
		visible = 1 - visible;
		drawline();
		tracking = 0;
		break;
	case 2:	/* Horizontal */
		if(visible) drawline();
		angle = 0;
		cangle = cos(angle); sangle = sin(angle);
		drawline();
		tracking = visible = 1;
		break;
	case 3:	/* Vertical */
		if(visible) drawline();
		angle = 90;
		cangle = cos(angle); sangle = sin(angle);
		drawline();
		tracking = visible = 1;
		break;
	case 4:	/* Remember */
		oldcenter = Center; oldangle = angle;
		break;
	case 5:	/* Restore */
		if(visible) drawline();
		Center = oldcenter; angle = oldangle;
		cangle = cos(angle); sangle = sin(angle);
		visible = 1; tracking = 0;
		drawline();
		break;
	case 6:	/* Deposit */
		drawline();
		break;
	case 7:	/* Pause */
		tracking = 0;
		break;
	case 8:	/* Exit */
		cursswitch(&skull);
		do; while(button123()==0);	/* wait for button push */
		while(button123())
			if(button13()){		/* only button 2 confirms exit */
				do; while(button123()!=0);
				cursswitch((Texture *) 0);
				return;
				}
		if(visible) drawline();
		exit();
		}
}

initial()
{
	xxmax = Drect.corner.x; xmin = Drect.origin.x;
	yymax = Drect.corner.y; ymin = Drect.origin.y;
	oldcenter.x = (xxmax+xmin)/2;
	oldcenter.y = (yymax+ymin)/2;
	Center = mouse.xy;
	cangle = cos(angle); sangle = sin(angle);
	dangle = 1;
	drawline();
}
