/*   S device driver for PostScript printers	*/
#include <stdio.h>
#include <time.h>
#include <pwd.h>
INCLUDE(device)

char *getenv(), *getlogin (), *ctime (), *user;

long time (), tloc;
struct passwd  *getpwuid ();
extern float F77_COM(bgrp)[];	/* graphical parameters */
define(`am',`F77_COM(bgrp)[$1-1]')

define(`MAXLINES',500)
int moved=0,lines=0,npage=1;
long current_color = -1;

char *dash_patterns[] = {
	"[120 40]",
	"[]",
	"[10 20]",
	"[40 40]",
	"[80 40]",
	"[130 30]",
	"[160 20 20 20]",
	"[80 20 20 20]",
	"[10 130]",
	"[60 50]"
};
	
int widths[] = { 1, 5, 10, 15, 20, 25, 30, 35, 40, 45 };

F77_SUB(zparmz,real=par,int=n)
{
	r_zparmz(F_REALP(par),F_INTP(n));
}

static r_zparmz(par, n)
float par[];
long *n;
{
	int i,horizontal;
	float xmax,ymax;

	for (i = 1; i <= 39; i++)
	am(i) = 0.0;

	am(20) = 80.0;		/* char size in rasters (tenths of a point) */
	am(21) = 140.0;

	if(*n>2 && par[2]){ horizontal = 1; xmax = 11.; ymax = 8.5; }
	else { horizontal = 0; xmax=8.5; ymax=11.; }

	am(22) = (xmax - par[0]) * 360.0;	/* x limits in rasters	 */
	am(23) = (xmax + par[0]) * 360.0;

	am(24) = (ymax - par[1]) * 360.0;	/* y limits in rasters	 */
	am(25) = (ymax + par[1]) * 360.0;

	am(26) = 0.5;		/* character offset	 */
	am(27) = 0.5;

	am(28) = 1.0 / 720;	/* raster size in inches - raster is 1/10 point	 */
	am(29) = am(28);

	am(30) = POSTSCRIPT;		/* device code number - a magic number
				   (same as `pic' device) to allow batch use */
	am(31) = 1;
	am(1) = 1;

	freopen("PostScript.out","a",stdout);
	printf("%%!PS-Adobe-1.0\n");
	user = getenv ("NAME");
	if (user == NULL) user = getlogin ();
	if (user == NULL) user = (getpwuid (getuid ())) -> pw_name;
	printf ("%%%%Creator: %s\n", user);
	tloc = time (0);
	printf("%%%%CreationDate: %s", ctime (&tloc));
	printf("%%%%Pages: (atend)\n");
	printf("%%%%DocumentFonts: Helvetica\n");
	if(horizontal == 1)
		printf("%%%%BoundingBox: %d %d %d %d\n",
			(int)am(24)/10, (int)am(22)/10, (int)am(25)/10, (int)am(23)/10);
	else
		printf("%%%%BoundingBox: %d %d %d %d\n",
			(int)am(22)/10, (int)am(24)/10, (int)am(23)/10, (int)am(25)/10);
	printf("%%%%EndComments\n");
	header();
	if(horizontal)
		printf("90 rotate\n0 %d translate\n",(int) (-ymax*720));
	F77_CALL(zejecz);
}

F77_SUB(zseekz,int=ix,int=iy)
{
	r_zseekz(F_INTP(ix),F_INTP(iy));
}

static r_zseekz(ix, iy)
long int *ix, *iy;
{
	static float line_type = -1, line_width = -1;

	if(lines) { printf("stroke\n"); lines = 0; }
	moved++;
	r_setcol((long)am(10));
	if (line_type != am(8)) {	/* set line type if changed	 */
		line_type = am(8);
		printf ("%s 0 setdash\n",dash_patterns[((int) line_type) % 10]);
	};
	
	if (line_width != am(9)) {	/* set line width if changed	*/
		line_width = am(9);
		printf ("%d setlinewidth\n",widths[((int) line_width) % 10]);
	};

	printf ("%d %d M\n", *ix, *iy);
}

F77_SUB(zlinez,int=ix,int=iy)
{
	r_zlinez(F_INTP(ix),F_INTP(iy));
}

static r_zlinez(ix, iy)
long *ix, *iy;
{
	printf ("%d %d L\n", *ix, *iy);
	if(++lines > MAXLINES) {
		printf ("stroke\n%d %d M\n", *ix, *iy);
		lines = 0;
		}
}

F77_SUB(zptchz,char=ich,real=crot)
{
	r_zptchz(F_CHARP(ich),F_REALP(crot));
}

static r_zptchz(ich, crot)
char *ich;
float *crot;
{
	printf ("(%c) %g Schar\n", *ich, am(18)/am(89));/* print the character */
}

F77_SUB(zejecz)
{
	if (moved){
		npage++;
		printf ("gsave showpage grestore\n");
		printf ("%%%%Page: %d %d\n",npage,npage);
		}
	moved = 0;
}

F77_SUB(zflshz)
{
	if(lines) { printf("stroke\n"); lines = 0; }
	fflush (stdout);
}

F77_SUB(zwrapz)
{
	printf ("gsave showpage grestore\n");
	printf("%%%%Trailer\n%%%%Pages: %d\n",npage);
	fflush (stdout);
}

F77_SUB(ztextz,real=xx,real=yy,char=buf,int=n,real=pos)
{
	r_ztextz(F_REALP(xx),F_REALP(yy),F_CHARP(buf),F_INTP(n),F_REALP(pos));
}

static r_ztextz(xx, yy, buf, n, pos)
float *xx, *yy, *pos;
char buf[];
int *n;
{
	int i;
	
	if (*n <= 0) {
		F77_CALL(zejecz);
		F77_CALL(zerrpz,char="ztextz",char="Number of characters not positive");
		return;
	}
	r_setcol((long)am(10));
	putchar('(');
	for (i = *n; i--; buf++) {
		switch (*buf) {
			case '(':
			case ')':
				putchar('\\');
		}
		putchar(*buf);
	}
	printf ("\) %g %g %g %g %g Stext\n", *xx * am(37) + am(36),
	*yy * am(39) + am(38), am(18)/am(89), am(48), *pos);
	moved++;
}

F77_SUB(zfillz)
{
	printf ("fill\n");
	lines = 0;
}

r_setcol(col)
long col;
{
	if(current_color == col) return;
	if(col == 0)
		printf("1.0 setgray\n");
	else
		printf("%f setgray\n", ((col-1)%10)/10.0);
	current_color = col;
}

F77_SUB(setcol,int=col)
{
	r_setcol(*F_INTP(col));
}

char *top[] = {
	"/M {moveto} def",
	"/L {lineto} def",
	"/oldcex 1 def",
	"/coffset 140 0.375 mul def",
	"",
	"/Stext",
	"  { /pos exch def",
	"    /srot exch def",
	"    /cex exch def",
	"    /ypos exch def",
	"    /xpos exch def",
	"    /str exch def",
	"",
	"    xpos ypos moveto",
	"    oldcex cex ne",
	"      { currentfont cex oldcex div scalefont setfont",
	"        /coffset  coffset cex oldcex div mul store",
	"        /oldcex cex store",
	"      } if",
	"   gsave",
	"	srot rotate",
	"	str stringwidth pop neg",
	"	pos mul",
	"	coffset neg rmoveto",
	"	str show",
	"    grestore",
	"  } store",
	"",
	"/Schar",
	"  { /cex exch def",
	"    /str exch def",
	"",
	"    oldcex cex ne",
	"      { currentfont cex oldcex div scalefont setfont",
	"        /coffset  coffset cex oldcex div mul store",
	"        /oldcex cex store",
	"      } if",
	"    str stringwidth pop neg 2 div coffset neg rmoveto",
	"    str show",
	"  }  store",
	"",
	"0.1 0.1 scale	% uses integer coordinates at 1/10's of a point",
	"1 setlinecap 1 setlinejoin",
	"/Helvetica findfont 140 scalefont setfont % font is 14 pt. Helvetica",
	"/oldcex 1 def",
	"/coffset 140 0.375 mul def",
	"%%EndProlog",
	"%%Page: 1 1",
	0
};

header()
{
	char **p;

	for(p=top ; *p ; p++) printf("%s\n", *p);
}
