FUNCTION regprt(
	z	/STR/
	names	/CHAR,OPTIONAL/
	ynames	/CHAR,OPTIONAL/
	correlation	/LGL,1,TRUE/
	)
NOPRINT
INCLUDE(io)
ARGSTR(z)
ARG(	r	/MATRIX/
	resid	/MATRIX/
	corth	/MATRIX/
	coef	/MATRIX/
	int	/LGL/
	sqrtw	/MATRIX,OPTIONAL/
	&
	)
if(MISSING(names))  ARG(names/CHAR,OPTIONAL/,&)
if(MISSING(ynames))  ARG(ynames/CHAR,OPTIONAL/,&)
if(MISSING(correlation))  ARG(correlation/LGL,1,TRUE/,&)
RETURN(FILTER,&)
ARGSTR
STATIC( integer n,p,ny,nynam,ncopy,namep )
n=NROW(resid); p=NROW(r); ny=NCOL(resid)
if(!MISSING(ynames)) nynam=LENGTH(ynames)
else nynam=0
STRUCTURE(
	res	/LIKE(resid)/
	cov	/MATRIX,p,p/
	cor	/MATRIX,p,p/
	diag	/REAL,p/
	stderr	/REAL,p/
	t	/REAL,p/
	rms	/REAL,ny/
	table	/MATRIX,p,3/
	aovlab	/CHAR,3/
	xnames	/CHAR,p/
	)

namep = 1
if(int & (MISSING(names) | LENGTH(names)<p)) {
	xnames[namep]=istrng("Intercept",9)
	namep=2
	}
if(!MISSING(names)) {
	ncopy=min0(LENGTH(names),p-namep+1)
	call icopy(names,xnames[namep],ncopy)
	namep=namep+ncopy
	}
for(; namep<=p; namep=namep+1) {
	ENCODE("x",I(namep,0))
	xnames[namep]=istrng(BUFFER,BUFPOS)
	CLEAR
	}
if(!MISSING(sqrtw))
	for(i=1;i<=n;i=i+1)
		for(k=1;k<=ny;k=k+1)
			res[i,k]=res[i,k]*sqrtw[i]
aovlab[1]=istrng("Coef",4)
aovlab[2]=istrng("Std Err",7)
aovlab[3]=istrng("t Value",7)
if(int) i=1
else i=0
call regcov(p,r,cov,cor,diag)
for(k=1;k<=ny;k=k+1) {
	if(ny > 1) {
		if(k > nynam)
			FPRINT(OUTFC,"Regression for y",I(k,0),":")
		else
			FPRINT(OUTFC,"Regression for ",C(TEXT(ynames[k])),":")
		SKIP(OUTFC)
		}
	call regsum(n,p,corth[1,k],coef[1,k],stderr,t,diag,res[1,k],rms[k],rsq,fval,int)
	call rcopy(coef[1,k],table,p)
	call rcopy(stderr,table[1,2],p)
	for(j=1; j<=p; j=j+1)	# round the t-stats to 2 decimals
		if(!NA(t[j])) t[j] = sign(aint(abs(t[j])*100.+.5)/100.,t[j])
	call rcopy(t,table[1,3],p)
	call prtmas(VALUE(table),REAL,p,3,xnames,p,aovlab,3,FULL_MATRIX,FALSE)
	FPRINT(OUTFC,"N =",I(n))
	FPRINT(OUTFC,"Residual Standard Error =",R(rms[k]))
	FPRINT(OUTFC,"Multiple R-Square =",R(rsq))
	FPRINT(OUTFC,"F Value =",R(fval)," on",I(p-i),COMMA,I(n-p)," df")
	SKIP(OUTFC)
	rms[k]=rms[k]**2
	}
if(correlation){
	if(ny == 1) {
		for(i=1;i<=p;i=i+1)
			for(j=1;j<=p;j=j+1)
				cov[i,j] = cov[i,j]*rms[1]
		FPRINT(OUTFC,"Covariance matrix of coefficients:")
		}
	else
		FPRINT(OUTFC,"Standardized covariance matrix of coefficients:")
	call prtmas(VALUE(cov),REAL,p,p,xnames,p,xnames,p,LOWER_MATRIX,FALSE)	# lower triangle with diagonal
	if(ny > 1) {
		FPRINT(OUTFC,"Squared standard errors:")
		call prtvc2(PDATA(rms),FALSE)
		SKIP(OUTFC)
		}
	FPRINT(OUTFC,"Correlation matrix of coefficients:")
	call prtmas(VALUE(cor),REAL,p,p,xnames,p,xnames,p,SUBDIAG_MATRIX,FALSE)	#lower triangle without diagonal
	}
if(ny == 1) {
	COERCE(coef/VECTOR/)
	COERCE(resid/VECTOR/)
	COERCE(corth/VECTOR/)
	if(!MISSING(sqrtw)) COERCE(sqrtw/VECTOR/)
	}
RETURN(coef,resid,r,corth,int,names=xnames,&)
if(!MISSING(sqrtw))RETURN(sqrtw,&)
if(!MISSING(ynames))RETURN(ynames,&)
RETURN(FILTER)
END
