FUNCTION sabl(
	x		/TS/
	power		/REAL,7,pwrs/
	calendar	/LGL,1,FALSE/
	trend		/INT,1,11/
	seasonal	/INT,1,15/
	revisions	/LGL,1,FALSE/
	)
lenx=LENGTH(x)
ncyc=int(TNPER(x))
iyear=int(TSTART(x))
imonth=(TSTART(x)-float(iyear))*TNPER(x)+1.5
lyear=int(TEND(x))
lmonth=(TEND(x)-float(lyear))*TNPER(x)+1.5
if(ncyc <= 1) FATAL(Time series must have nper > 1)
if(imonth<=0||imonth>ncyc) FATAL(Initial month out of bounds)
if(lmonth<=0||lmonth>ncyc) FATAL(Last month out of bounds)
STRUCTURE(
	powout		/REAL,1/
	powt		/REAL,LENGTH(power)/
	xml		/REAL,lenx/
	transformed	/LIKE(x)/
	tren		/LIKE(x)/
	seascomp	/TS,TSTART(x),TEND(x)+1,TNPER(x)/
	calcomp		/LIKE(seascomp)/
	irregular	/LIKE(x)/
	adjusted	/LIKE(x)/
	weights		/REAL,lenx/
	revs		/REAL,lenx/
	)
STATIC(real pwrs(7))
INITIAL(pwrs/-1,-.5,-.25,0.,.25,.5,1/)
call rangev(x,lenx,xl,xu)
if (xl<=0) {
	if(!MISSING(power)) {
		if((LENGTH(power)!=1)||((LENGTH(power)==1)&(power!=1)))
			WARNING(Data not transformable because non-positive values) }
	power=1
	LENGTH(power)=1
	}
if ((ncyc!=12) & calendar) { calendar=FALSE
	WARNING(No calendar because not monthly data) }
if (trend<=2) { trend=11
	WARNING(Trend smoothing window length set to 11) }
	else { if (mod(trend,2)!=1) { trend=trend-1
		WARNING(Trend window length shortened by 1 to be odd) } }
if (seasonal<=2) { seasonal=15
	WARNING(Seasonal smoothing window length set to 15) }
	else { if (mod(seasonal,2)!=1) { seasonal=seasonal-1
		WARNING(Seasonal window length shortened by 1 to be odd) } }
call sabl(x,imonth,iyear,lmonth,lyear,lenx,ncyc,LENGTH(revs),
	power,LENGTH(power),calendar,trend,seasonal,revisions,
	powout,powt,xml,
	transformed,tren,calcomp,seascomp,irregular,adjusted,weights,revs)

RETURN(trend=tren,seasonal=seascomp,irregular,transformed,adjusted,&)
if(calendar) RETURN(calendar=calcomp,&)
RETURN(power=powout,&)
if(LENGTH(power)>1) RETURN(tstat=powt,&)
if(revisions) RETURN(revisions=revs,&)
RETURN(weights)
END
