FUNCTION tbl( x/MATRIX,ANY, NAOK/,
	file/CHAR,1,STRING(tbl.out)/,
	head/CHAR,OPTIONAL/,
	rowlab/CHAR,OPTIONAL/,
	collab/CHAR,OPTIONAL/
	options/CHAR,OPTIONAL/
	)

STATIC(integer fd, sattac; CHARACTER(item,2))

nrow=NROW(x); ncol=NCOL(x)
if((!MISSING(rowlab))&& LENGTH(rowlab)<nrow)FATAL(not enough row labels)
if((!MISSING(collab))&& LENGTH(collab)<ncol)FATAL(not enough column labels)
fd=sattac(TEXT(file),WRITE,AUTO)

FPRINT(fd,".T","S") #nonsense needed because TS is a macro
call tblopt(fd,options,LENGTH(options))

if(!MISSING(rowlab))ncol=ncol+1
call tblfmt(fd,MODE(x),NCOL(x),MISSING(head),MISSING(rowlab),MISSING(collab))

if(!MISSING(head)){FPRINT(fd,C(TEXT(head))); FPRINT(fd,"=")}
if(!MISSING(collab)){
	if(!MISSING(rowlab))ENCODE(TABCHAR)
	for(j=1; j<=NCOL(x); j=j+1) {
		ENCODE(C(TEXT(collab[j])))
		if(j<NCOL(x))ENCODE(TABCHAR)
		}
	FPRINT(fd); FPRINT(fd,"_")
	}
call tbldat(fd,MODE(x),nrow,NCOL(x),VALUE(x),VALUE(rowlab))
FPRINT(fd,".TE")
call sdetac(fd)
END
