#include "icdef.h"
main() {
#include "extern.h"
	/*
	"regular" grammar, tokens subscripted by states:	| actions:
	________________________________________________________|________________________________________
								|
	 garbage						| print
	0       0						|
								|_
	 FUNCTION dec | ARG ( dec keydec &  dec  keydec  )	| "FUNCTION dec" causes "FUNCTION(dec)" to be printed
	0        1   2|4   2 3   3      3 33   33      33 4	| and symbol table to be erased.
								| each "dec" in states 3 or 33 is printed as "ARG(dec)"
								|_commas are ignored in states 3 and 33
	 STRUCTURE ( dec )					| each "dec" in state 6 is printed as
	4         5 6   6 4					| "STRUCTURE(dec)"
								|_commas are ignored in state 6
	 ALLOCATE ( dec )					| each "dec" in state 8 is printed as "ALLOCATE(dec)"
	4        7 8   8 8 4		"dec"  is  printed	| commas are ignored in state 8
					with the first "/"	|_
	 ALLARG (  name  ,  string  )	turned  into   "("	| print, enter name in sym. tab.
	4      9 10    11 12      11 4	and the second "/"	|
					isn't     printed.	|_
	 SPECIAL  (  garbage  )		the  variable name	| print, without change
	4       14 15       15 4	and its  mode  are	|
					entered   in   the	|_
	 COERCE  (  dec  )		symbol table.		| each "dec" in state 20 is printed as "COERCE(dec)"
	4      13 20   20 4					| commas are ignored in state 20
								|_
	 SWITCH  MODE  (  name  )  { }				| enter name on stack
	4      22    23 24    25 31 4 4				| print "switch(MODE(name)) { }"
								|_
	 DEFAULT  | CASE  TYPE  TYPE           :		| enter the "or" of the types in the sym. tab
	4       30|4    27    28    29 28,29,30 4		| for the variable on top of the stack
								| "DEFAULT" causes type "undefined" to be entered
								| print "case type:", where "type" is the first
								|_type given, or "default:".
	 quote							| print
	4     4							|
								|_
	 number							| print, note: a single dot is considered as a number
	4      4						|
								|_
	 comment						| print
	4       4						|
								|_
	 name							| print
	4    4							|
								|_
	 identifier						| print "[CILR]DATA(identifier)" unles next token is "<-" or "["
	4          16						|
								|_
	  <-  name  (  garbage  )				| print "SFUN(identifier, name, garbage)"
	16  34    32 15       15 4				| where "identifier" is the thing which set state to 16
								|_
	  [ ]							| print "[CILR]DATA(identifer," for the first bracket, and
	16 4 4							| print ")" for the second bracket
								| note: the grammar is unambiguous even if parens were
								|       used instead of brackets, because "[" is only special
								|       in state 16 and "(" is not allowed in state 16, and
								|       also because neither "[" nor ")" have any meaning
								|_      to the automaton in state 4.
	 garbage						| print
	4       4						|
								|_
	 END  (  name         )					| print, and make sure "name" matches the one
	4   17 18    19  18,19 0				| given in state 1
								|_
	  empty							| recognized after "END" so that "garbage" can be
	17     0						| recognized in fewer states.

	Space and tab are legal in all states, and are printed in states 0, 4, and 15.
	Newline is legal in all states except 15.
	Anything at all is allowed in state 0.
	Anything but '\n' is allowed in state 15 as long as there
	are not more right parentheses than left parentheses.

	*/
	/* main routine:
	  It is a finite automaton except that it counts paren level in state 15,
	  and brace level in state 4. (plevel & blevel, resp)
	  The variable "usedf" is set to 0 if the current token hasn't
	  been used, and 1 if the current token has been used.
	  Since some states perform actions which are similar to actions
	  performed by other states, or the actions don't depend very much on
	  the token read, the program switches on "state1" first,
	  then it switches on "token".  In state 0 or 15, the program
	  mainly copies its input onto the output.
	  States 16, 17 & 14 are just like state 4, except in a very few cases.
	  The main routine also sets state2 (the automaton that parses
	  "dec's") and state3 (the automata that parse strings)
	Error handling:
	  If an error is detected, state1 is set to -1.  ostate has the
	  to the value of state1 at the top of the loop, so state1 is reset
	  as if the input causing the error was not read.  The type of error is
	  deduced from state1, state2 & state3 at the time of the error.
	*/
	int blevel, yes, switchf, plevel, i, ostate, fatal;
	for(i=0; i<TABLESIZE; i++) {
		ttable[i][0]=0;
		mtable[i]=0;
		}
	/* function "dprint" looks up all words in the symbol table
	  and if one is "SPECIAL" the balanced string after it is
	  printed.
	*/
	enter("DATA",SPECIAL);	/* these lines can be replaced by initial values */
	enter("RDATA",SPECIAL);	/*		      replace			 */
	enter("IDATA",SPECIAL);	/*		      replace			 */
	enter("CDATA",SPECIAL);	/*		      replace			 */
	enter("LDATA",SPECIAL);	/*		      replace			 */
	enter("DATANAME",SPECIAL); /*		      replace			 */
	enter("TSTART",SPECIAL); /*		      replace			 */
	enter("TEND",SPECIAL);	/*		      replace			 */
	enter("TNPER",SPECIAL); /*		      replace			 */
	enter("P",SPECIAL);	/*		      replace			 */
	enter("CHAIN",SPECIAL);	/*		      replace			 */
enter("DEBUG",SPECIAL); /*		    replace		*/
enter("NAME",SPECIAL); /*		    replace		*/
enter("COPY",SPECIAL); /*		    replace		*/
enter("TSRANGE",SPECIAL); /*		    replace		*/
enter("FIRSTENT",SPECIAL); /*		    replace		*/
enter("NEXTENT",SPECIAL); /*		    replace		*/
enter("LASTENT",SPECIAL); /*		    replace		*/
enter("HSTYPE",SPECIAL); /*		    replace		*/
enter("HDTYPE",SPECIAL); /*		    replace		*/
enter("ARGSTR",SPECIAL); /*		    replace		*/
enter("FILTER",SPECIAL); /*		    replace		*/
enter("KEYNAME",SPECIAL); /*		    replace		*/
enter("NAMODE",SPECIAL); /*		    replace		*/
enter("NEXTARG",SPECIAL); /*		    replace		*/
enter("PDIM",SPECIAL); /*		    replace		*/
enter("PTSP",SPECIAL); /*		    replace		*/
enter("SETMODE",SPECIAL); /*		    replace		*/
enter("SNAME",SPECIAL); /*		    replace		*/
enter("STRING",SPECIAL); /*		    replace		*/
enter("TSMODE",SPECIAL); /*		    replace		*/
	enter("RANGE",SPECIAL);	/*		      replace			 */
	enter("AXIS",SPECIAL);	/*		      replace			 */
	enter("NROW",SPECIAL);	/*		      replace			 */
	enter("NCOL",SPECIAL);	/*		      replace			 */
	enter("LENGTH",SPECIAL); /*		      replace			 */
	enter("VALUE",SPECIAL);	/*		      replace			 */
	enter("RETURN",SPECIAL); /*		      replace			 */
	enter("MISSING",SPECIAL); /*		      replace			 */
	enter("FATAL",SPECIAL);	/*		      replace			 */
	enter("WARNING",SPECIAL); /*		      replace			 */
	enter("MESSAGE",SPECIAL); /*		      replace			 */
	enter("FIND",SPECIAL); /*		      replace			 */
	enter("FROM",SPECIAL);
	enter("INSERT",SPECIAL);
	enter("LIKE",SPECIAL);
	enter("VSET",SPECIAL);
	enter("PDATA",SPECIAL);
	/* fatal should be set if no further processing is desired
	  the program currently recognizes no fatal errors */
	fatal=0;
	state1=0;
	plevel=0;
	blevel=0;
	letterf=0;
	/* letterf is set to one if:
	   (1) the last character read was a letter, or
	   (2) letterf was set to one before the last character read and the last
	       character read was a digit.
	*/
	token=yylex();
	while(token!=0) {
		usedf=1;
		ostate=state1;
		if(state1==16 && token!= '[' && token!= SPACE && token!=ASSIGN) {
			yes=mprint(mtable[index]);
			printf("%s)", text);
			if(yes!=-1)state1=4;
			else {
				state1= -1;
				usedf=0;
				}
			}
		else if(state1==17 && token!=SPACE && token!='(') {
			state1=0;
			}
		else if(state1==14 && token!=SPACE && token!='(') {
			state1=4;
			}
		if(state1==0 || state1==15) {
			switch(token) {
				case FUNCTION:
				case '\n':
				case '`':
				case '(':
				case ')':
					switchf=1;
					break;
				default:
					switchf=0;
					echo();
				} /* end of switch */
			} /* end of if */
		else /* if state isn't 0 or 15 */ {
			switchf=1;
			}
		if(switchf==1) switch(token) {
			case FUNCTION: switch(state1) {
				case 0: state1=1;
					printf("FUNCTION(");
					for(i=0; i<TABLESIZE; i++) {
						if(mtable[i]==SPECIAL ) continue;
						ttable[i][0]=0;
						mtable[i]=0;
						}
					break;
				case 4:
				case 15: echo(); break;
				default: state1= -1;} break;
			case ARG: if(state1==4) {
					state1=2;
					}
				else {
					state1= -1;
					}
				break;
			case STRUCTURE: if(state1==4) {
					state1=5;
					}
				else {
					state1= -1;
					}
				break;
			case ALLOCATE: if(state1==4) {
					state1=7;
					}
				else {
					state1= -1;
					}
				break;
			case ALLARG: if(state1==4) {
					state1=9;
					echo();
					}
				else {
					state1= -1;
					}
				break;
			case CASE: if(state1==4) {
				/* yylex recognises TYPEs and SPECIALs only in
				   lex start state SSTATE */
					state1=27; BEGIN SSTATE; printf("case ");
					}
				else {
					state1= -1;
					}
				break;
			case DEFAULT: if(state1==4) {
					state1=30; typeno=0; printf("default");
					}
				else {
					state1= -1;
					}
				break;
			case COERCE: printf("%s(",yytext);
				 if(state1==4) {
					state1= 13; 
					}
				else {
					state1= -1;
					}
				break;
			case SWITCH: if(state1==4) {
					state1=22; printf("switch(");
					}
				else {
					state1= -1;
					}
				break;
			case MODE: switch(state1) {
				case 4: state1=14; echo(); break;
				case 22: state1=23; echo(); break;
				default: state1= -1; } break;
			case TYPE: switch(state1) {
				case 4: echo(); break;
				case 27: typeno=0;
					BEGIN SSTATE;
				case 28: state1++;
					typeno |= typeval;
					break;
				default: state1= -1; } break;
			case END: if(state1==4) {
					state1=17; echo();
					}
				else {
					state1= -1;
					}
				break;
			case SPECIAL: if(state1==4) {
					state1=14; echo();
					}
				else {
					state1= -1;
					}
				break;
			case '.':
			case DIGIT: switch(state1) {
				case 12: if((state2=string())==7||state2==8||state2==11)
						state1=11;
					else {
						state1= -1; }
					printf("%s",text);
				case 4: if((state2=string())==7||state2==8||state2==11||state2==6)
					/* note: if state2==6, input was a single dot */
						state1=4;
					else {
						state1= -1; }
					printf("%s",text); break;
				default: state1= -1;} break;
			case 'e':
			case LETTER: switch(state1) {
				case 1: if((state3=dec())==1||state3==5) state1=2;
					else  {
						state1= -1;
						}
					print(12, name);
					if((decprint())==-1) state1= -1;
					for(i=0; i<NAMESIZE; i++) {
						fname[i]=name[i];
						if(name[i]==0) break;
						}
					break;
				case 4: if((state2=string())==1) {
						state1=16;
						if((yes=lookup(text))==0) {
							state1=4;
							printf("%s",text);
							}
						else if(MAYBE) {
							state1= -1;
							}
						/* else if YES, do nothing */
						}
					else {
						state1= -1; }
					break;
				case 10: if((state2=string())==1) state1=11;
					else {
						state1= -1; }
					if((enter(text, 0))==-1) state1= -1;
					printf("%s",text);
					break;
				case 18: if((state2=string())==1) state1=19;
					else {
						state1= -1;
						break; }
					for(i=0; i<NAMESIZE; i++) {
						if(fname[i]!=text[i]) {
							state1= -1; }
						if(text[i]==0) break;
						}
					printf("%s",text);
					break;
				case 12: if((state2=string())==1) state1=11;
					else {
						state1= -1; }
					printf("%s",text);
					break;
				case 34: if((state2=string())==1) state1=32;
					else state1= -1;
					printf("%s, ",text);
					break;
				case 24: if((state2=string())==1) state1=25;
					else state1= -1;
					printf("%s",text);
					if((enter(text,0))==-1) state1= -1;
					varstack[blevel]=index;
					break;
				case 33:
				case 3: if((state3=dec())==1||state3==5||state3==6||state3==10)
						state1=3;
					else {
						state1= -1; }
					if((enter(name, typeno))==-1) state1= -1;
					if(state3==10 || state3==6) printf("KEY");
					printf("ARG(");
					print(12, name);
					if((decprint())==-1) state1= -1;
					break;
				case 6: if((state3=dec())==1||state3==5)
						state1=6;
					else {
						state1= -1; }
					if((enter(name, typeno))==-1) state1= -1;
					printf("STRUCTURE(");
					print(12, name);
					if((decprint())==-1) state1= -1;
					break;
				case 8: if((state3=dec())==1|| state3==5)
						state1=8;
					else {
						state1= -1; }
					if((yes=lookup(name))==-1) state1= -1;
					else if(NO) {
						fprintf(stderr,"ERROR: structure allocated but not declared\n");
						state1= -1;
						}
					enter(name, typeno);
					printf("ALLOCATE(");
					print(12, name);
					if((decprint())==-1) state1= -1;
					break;
				case 20: if((state3=dec())==1 || state3==5)
						state1=20;
					else state1= -1;
					if((enter(name,typeno))==-1) state1= -1;
					print(12, name);
					if((decprint())==-1) state1= -1;
					break;
				default: state1= -1;} break;
			case SPACE:
			case '\n': switch(state1) {
				/* note: control doesn't get to here if token==SPACE
				   unless state1==4 */
				case 27:
				case 28:
					BEGIN SSTATE;
					break;
				case 15: state1= -1; break;
				case 0:
				case 4: echo(); } break;
			case ',': switch(state1) {
				case 11: state1=12;
				case 4: echo();
				case 6:
				case 8:
				case 20:
				case 33:
				case 3: break;
				default: state1= -1;} break;
			case '#':
			case '"':
			case '`': switch(state1) {
				case 0:
				case 15:
				case 4: if((state2=string())==3||state2==5||state2==13) /* NULL */;
					/* this if-else with a NULL was used because all other
					   if's of state2 use or-bars */
					else {
						state1= -1; }
					printf("%s",text);
					break;
				case 12: if((state2=string())==3||state2==5||state2==13) state1=11;
					else {
						state1= -1; }
					printf("%s",text); break;
				default: state1= -1;} break;
			case ASSIGN: switch(state1) { /* Will not occur (SFUN feature has been deleted) */
				case 4: echo(); break;
				case 16: printf("SFUN(%s, ", text);
					state1=34; break;
				default: state1= -1; } break;
			case ':': switch(state1) {
				case 4: echo(); break;
				case 27: fprintf(stderr,"ERROR: missing constant in CASE statement\n");
					state1= -1;
					break;
				case 28:
				case 29: if((tprint(31&typeno))==-1) state1= -1;
				case 30: state1=4;
					echo();
					if(blevel<1 || varstack[blevel-1]==-1) {
						fprintf(stderr, "ERROR: case not in switch\n");
						state1= -1;
						break;
						}
					mtable[varstack[blevel-1]]=typeno; } break;
			case '[': switch(state1) {
				case 16: if((mprint(mtable[index]))==-1) state1= -1;
					printf("%s, ",text);
					state1=4; break;
				case 4: printf("("); break; /* not an S structure*/
				default: state1= -1; } break;
			case ']': if(state1==4) {
					printf(")");
					}
				else {
					echo();
					state1= -1;
					}
				break;
			case '(': switch(state1) {
				case 14: state1 = 15;
				case 15: plevel++;
					echo(); break;
				case 32: state1=15; plevel++; break;
				case 2: state1=3; break;
				case 5: state1=6; break;
				case 7: state1=8; break;
				case 13: state1=20;  break;
				case 23: state1=24; echo(); break;
				case 9: state1=10;
				case 0:
				case 4: echo(); break;
				case 17: state1=18; echo(); break;
				default: state1= -1; } break;
			case ')': switch(state1) {
				case 15: plevel--;
					echo();
					if(plevel==0) state1=4;
					break;
				case 25: state1=31; echo(); printf(") "); break;
				case 11: echo(); state1=4; break;
				case 3: printf("ENDARGS\n");
				case 33:
				case 6:
				case 20:
				case 8: state1 =4; break;
				case 19:
				case 18: state1=0;
				case 0:
				case 4: echo(); break;
				default: state1= -1; } break;
			case '{': switch(state1) {
				case 4: varstack[blevel]= -1;
				case 31: state1=4;
					if(++blevel>=STACKSIZE) {
						fprintf(stderr, "ERROR: brace-level too deep\n");
						state1= -1;
						}
					echo();
					break;
				default: state1= -1; } break;
			case '}': switch(state1) {
				case 4: echo();
					if(--blevel<0) {
						blevel++;
						fprintf(stderr, "ERROR: brace-level negative\n");
						state1= -1;
						}
					if(varstack[blevel]!=-1)mtable[varstack[blevel]]=0;
					break;
				default: state1= -1; } break;
			case '&': switch(state1) {
				case 4: echo(); break;
				case 3: state1=33; break;
				default: state1= -1; } break;
			case '+':
			case '\047':
			case '/':
			case '=':
			case GARBAGE: if(state1==4) {
					echo();
					}
				else {
					state1= -1;
					}
				break;
			default: fprintf(stderr, "SYSTEM ERROR (1) -- unrecognized input\n");
					state1= -1;
			} /* end of switch */
			/* end of if */
		if(state1==-1) {
			state1=ostate;
			if(fatal==1) fprintf(stderr, "FATAL ");
			fprintf(stderr, "ERROR in line %d: ", yylineno);
			switch(state1){
				/* note: in some states it is assumed that errors go back
				   more than one token, and the state was reset to 4 */
				case  0: fprintf(stderr,"bad text before FUNCTION keyword\n");
					break;
				case  1: fprintf(stderr,"bad declaration of function\n");
					break;
				case  2: fprintf(stderr,"( expected before argument list\n");
					break;
				case  3: fprintf(stderr,"bad argument declaration\n");
					break;
				case  4: fprintf(stderr,"syntax error\n");
					break;
				case  5: fprintf(stderr,"( expected after STRUCTURE\n");
					break;
				case  6: fprintf(stderr,"bad declaration of STRUCTURE\n");
					break;
				case  7: fprintf(stderr,"( expected after ALLOCATE\n");
					break;
				case  8: fprintf(stderr,"bad declaration of ALLOCATE\n");
					break;
				case  9: fprintf(stderr,"( expected after ALLARG\n");
					break;
				case 10: fprintf(stderr,"bad name for ALLARG dummy\n");
					break;
				case 11: fprintf(stderr,"comma expected after ALLARG dummy\n");
					break;
				case 12: fprintf(stderr,"bad second argument to ALLARG\n");
					break;
				case 13: fprintf(stderr,"( expected after COERCE\n");
					break;
				case 14: fprintf(stderr,"( expected after macro name\n");
					break;
				case 15: fprintf(stderr,"bad argument to macro\n");
					break;
				case 16: fprintf(stderr,"bad character following a variable name\n");
					state1=4;
					break;
				case 17: fprintf(stderr,"( expected after END\n");
					break;
				case 18: fprintf(stderr,"bad function name following END\n");
					break;
				case 19: fprintf(stderr,") expected after function name\n");
					break;
				case 20: fprintf(stderr,"bad declaration of COERCE\n");
					break;
				case 22: fprintf(stderr,"bad SWITCH keyword\n");
					state1=4;
					break;
				case 23: fprintf(stderr,"( expected after SWITCH statement\n");
					state1=4;
					break;
				case 24: fprintf(stderr,"bad name in SWITCH statement\n");
					state1=4;
					break;
				case 25: fprintf(stderr,") expected after name in SWITCH statemtnt\n");
					state1=4;
					break;
				case 27: fprintf(stderr,"bad first type in CASE statement\n");
					state1=4;
					break;
				case 28: fprintf(stderr,"bad second type in CASE statement\n");
					state1=4;
					break;
				case 29: fprintf(stderr,": expected after CASE statement\n");
					state1=4;
					break;
				case 30: fprintf(stderr,": expected after DEFAULT statement\n");
					state1=4;
					break;
				case 31: fprintf(stderr,"{ expected after SWITCH statement\n");
					state1=4;
					break;
				case 32: fprintf(stderr,"( expected after S-function name\n");
					state1=4;
					break;
				case 33: fprintf(stderr,"bad argument declaration after &\n");
					break;
				default: fprintf(stderr,"SYSTEM ERROR (4) -- bad state: %d\n", state1);
				} /* end of switch -- errors in state1 */
			switch(state3) {
				/* some states are "ok". (they don't show any error from dec) */
				case -1: fprintf(stderr,"ERROR in line %d: overflow\n",yylineno);
					break;
				case  0: fprintf(stderr,"ERROR in line %d: null declaration\n",yylineno);
					break;
				case  1:
					break;
				case  2: fprintf(stderr,"ERROR in line %d: missing type\n",yylineno);
					break;
				case  3: fprintf(stderr,"ERROR in line %d: missing closing /\n",yylineno);
					break;
				case  4: fprintf(stderr,"ERROR in line %d: extra comma\n",yylineno);
					break;
				case  5:
					break;
				case  6: fprintf(stderr,"WARNING in line %d: 'name =' in declaration\n",yylineno);
					break;
				case  7: fprintf(stderr,"ERROR in line %d: missing type in key dec\n",yylineno);
					break;
				case  8: fprintf(stderr,"ERROR in line %d: missing right slash in key dec\n",yylineno);
					break;
				case  9: fprintf(stderr,"ERROR in line %d: extra comma in key dec\n",yylineno);
					break;
				case 10: fprintf(stderr,"WARNING in line %d: 'name =' in declaration\n",yylineno);
					break;
				case 11: fprintf(stderr,"ERROR in line %d: , or / expected after mode\n",yylineno);
					break;
				case 16: fprintf(stderr,"ERROR in line %d: , or / expected after mode in key dec\n",yylineno);
					break;
				default: fprintf(stderr,"ERROR in line %d: SYSTEM ERROR (3) -- bad state %d\n",yylineno,state3);
				} /* end of switch -- errors for state3 */
			switch(state2) {
				case -1: fprintf(stderr,"ERROR in line %d: overflow\n",yylineno);
					break;
				case  0:
					break;
				case  1:
					break;
				case  2: fprintf(stderr,"ERROR in line %d: missing right-quote\n",yylineno);
					break;
				case  3:
					break;
				case  4: fprintf(stderr,"ERROR in line %d: missing double-quote\n",yylineno);
					break;
				case  5:
					break;
				case  6: fprintf(stderr,"WARNING in line %d: number without digits\n",yylineno);
					break;
				case  7:
					break;
				case  8:
					break;
				case  9: fprintf(stderr,"ERROR in line %d: missing exponent\n",yylineno);
					break;
				case 10: fprintf(stderr,"ERROR in line %d: missing digits in exponent field\n",yylineno);
					break;
				case 11:
					break;
				case 12: fprintf(stderr,"ERROR in line %d: missing new-line after comment\n",yylineno);
					/* note: on GCOS, a missing linefeed is impossible */
					break;
				case 13:
					break;
				case 14: fprintf(stderr,"ERROR in line %d: unadorned sign\n",yylineno);
					break;
				default: fprintf(stderr,"ERROR in line %d: SYSTEM ERROR (8) -- bad state %d\n",yylineno,state2);
				} /* end of switch -- errors in state2 */
			state3=1;
			state2=1;
			} /* end of if state1==-1 */
		if(fatal==1) break;
		if(usedf==1) {
			if(state1==4) BEGIN SSTATE;
			token=yylex();
			}
		} /* end of while */
	if(state1!=0) {
		fprintf(stderr,"ERROR in line %d: unexpected EOF\n", yylineno);
		}
	return fatal;
	} /* end of function icomp */
