SUPPORT(cio,		interface to C i/o routines)

F77_SUB(cread, int=fd, int=buf, int=n, int=mode, int=nactual)
{
	r_cread(F_INTP(fd),F_INTP(buf),F_INTP(n),F_INTP(mode),F_INTP(nactual));
}

F77_SUB(ccread, int=fd, char=buf, int=n, int=mode, int=nactual)
{
	r_cread(F_INTP(fd),(int *)F_CHARP(buf),F_INTP(n),F_INTP(mode),F_INTP(nactual));
}

static r_cread(fd, buf, n, mode, nactual)
long *fd, *buf, *n, *mode, *nactual;
	{
	unsigned nbytes, factor, read();
	factor = ( (int) *mode == CHAR ? 1 : sizeof(long) );
	nbytes = ( (unsigned) *n ) * factor; /*convert words or chars to chars*/
	*nactual = (long) read( (int) *fd, (char *)buf, nbytes ) / factor;
	}


F77_SUB(cwrite, int=fd, int=buf, int=n, int=mode, int=nactual)
{
	r_cwrite(F_INTP(fd),F_INTP(buf),F_INTP(n),F_INTP(mode),F_INTP(nactual));
}

static r_cwrite(fd, buf, n, mode, nactual)
long *fd, *buf, *n, *mode, *nactual;
	{
	unsigned nbytes, factor, write();
	factor = ( (int) *mode == CHAR ? 1 : sizeof(long) );
	nbytes = ( (unsigned) *n ) * factor; /*convert words or chars to chars*/
	*nactual = (long) write( (int) *fd, (char *)buf, nbytes ) / factor;
	}

static long r_cseek(fd, offset, base)
long *fd, *offset, *base;
	{
	long lseek();
	return( lseek( (int) *fd, *offset, (unsigned) *base) );
	}

long F77_SUB(cseek, int=fd, int=offset, int=base)
{
	return( r_cseek(F_INTP(fd),F_INTP(offset),F_INTP(base)) );
}

static long r_copen(file, perms)
char *file; long *perms;
	{
	int open(),fd;
	fd =  open(file, (int) *perms) ;
	return( (long)fd );
	}

long F77_SUB(copen, char=file, int=perms)
{
	return( r_copen(F_CHARP(file),F_INTP(perms)) );
}

static long r_ccreat( file)
char *file;
	{
	char *mktemp(); char *dummy = "Stemp.XXXXXX", *s;
	if( *file == '\0'){
		s = dummy+6;
		while( *s )
			*s++ = 'X';
		file = mktemp(dummy); /* make a name for temp file */
		if( file != dummy )TERMINAL(too many temporary files - try again)
		}
	return( (long) creat(file, STDPERMS) );
	}

long F77_SUB(ccreat, char=file)
{
	return( r_ccreat(F_CHARP(file)) );
}

F77_SUB(cclose, int=fd )
{
	close( (int) *F_INTP(fd) );
}

F77_SUB(sclose, int=fd )
{
	close( (int) *F_INTP(fd) );
}
