ROUTINE(gsls,least-squares fit with re-orthogonalized Gram-Schmidt)
subroutine gsls(x,n,p,y,k,q,r,corth,b,resid,rank,z)

INCLUDE(print,gs)
integer p,k,n,rank,j
real x(n,p),y(n,k),q(n,p),r(p,p),corth(p,k),b(p,k),resid(n,k)
real z(1),dotv,rho

omega=0.; theta=1.4; sigma=PRECISION
for(j=1; j<=p; j=j+1) { #compute diagonals for preconditioning
	b(j,1)=dotv(x(1,j),n,x(1,j))
	if(b(j,1)>0.)b(j,1)=sqrt(b(j,1))
	}
call qrfact(n,p,x,q,r)
# compute residuals, orthogonal components
call rcopy(y,resid,n*k)
for(j=1; j<=k; j=j+1) {
	call orthog(n,p,q,resid(1,j),corth(1,j),rho,FALSE,p)
	if(fail)EPRINT("iteration for residuals failed on variable",I(j))
	}
call condu(r,p,z,b,rank) #check for ill-conditioning
if(rank<p)EPRINT("Warning:",I(p-rank)," underdetermined coefficients")
call backsu(r,p,p,corth,k,b)
return
end
