ROUTINE(tridib,		eigenvalues by bisection)
subroutine tridib(n,eps1,d,e,e2,lb,ub,m11,m,w,ind,ierr,rv4,rv5)
integer i,j,k,l,m,n,p,q,r,s,ii,m1,m2,m11,m22,tag,ierr,isturm
real d(n),e(n),e2(n),w(m),rv4(n),rv5(n)
#     this subroutine is a translation of the algol procedure bisect,
#     num. math. 9, 386-393(1967) by barth, martin, and wilkinson.
#     handbook for auto. comp., vol.ii-linear algebra, 249-256(1971).

real u,v,lb,t1,t2,ub,xu,x0,x1,eps1
real abs,amax1,amin1,float
integer ind(m)
#
#
#     this subroutine finds those eigenvalues of a tridiagonal
#     symmetric matrix between specified boundary indices,
#     using bisection.
#
#     on input-
#
#        n is the order of the matrix,
#
#        eps1 is an absolute error tolerance for the computed
#          eigenvalues.  if the input eps1 is non-positive,
#          it is reset for each submatrix to a default value,
#          namely, minus the product of the relative machine
#          precision and the 1-norm of the submatrix,
#
#        d contains the diagonal elements of the input matrix,
#
#        e contains the subdiagonal elements of the input matrix
#          in its last n-1 positions.  e(1) is arbitrary,
#
#        e2 contains the squares of the corresponding elements of e.
#          e2(1) is arbitrary,
#
#        m11 specifies the lower boundary index for the desired
#          eigenvalues,
#
#        m specifies the number of eigenvalues desired.  the upper
#          boundary index m22 is then obtained as m22=m11+m-1.
#
#     on output-
#
#        eps1 is unaltered unless it has been reset to its
#          (last) default value,
#
#        d and e are unaltered,
#
#        elements of e2, corresponding to elements of e regarded
#          as negligible, have been replaced by zero causing the
#          matrix to split into a direct sum of submatrices.
#          e2(1) is also set to zero,
#
#        lb and ub define an interval containing exactly the desired
#          eigenvalues,
#
#        w contains, in its first m positions, the eigenvalues
#          between indices m11 and m22 in ascending order,
#
#        ind contains in its first m positions the submatrix indices
#          associated with the corresponding eigenvalues in w --
#          1 for eigenvalues belonging to the first submatrix from
#          the top, 2 for those belonging to the second submatrix, etc.,37445065
#
#        ierr is set to
#          zero       for normal return,
#          3*n+1      if multiple eigenvalues at index m11 make
#                     unique selection impossible,
#          3*n+2      if multiple eigenvalues at index m22 make
#                     unique selection impossible,
#
#        rv4 and rv5 are temporary storage arrays.
#
#     note that subroutine tql1, imtql1, or tqlrat is generally faster
#     than tridib, if more than n/4 eigenvalues are to be found.
#
#     questions and comments should be directed to b. s. garbow,
#     applied mathematics division, argonne national laboratory
ierr = 0
tag = 0
xu = d(1)
x0 = d(1)
u = 0.0
#     ********** look for small sub-diagonal entries and determine an
#                interval containing all the eigenvalues **********
do i = 1,n {
	x1 = u
	u = 0.0
	if (i!=n)
		u = abs(e(i+1))
	xu = amin1(d(i)-(x1+u),xu)
	x0 = amax1(d(i)+(x1+u),x0)
	if (i!=1)
		if (abs(e(i))>PRECISION*(abs(d(i))+abs(d(i-1))))
			next 1
	e2(i) = 0.0
	}
#
x1 = amax1(abs(xu),abs(x0))*PRECISION*float(n)
xu = xu-x1
t1 = xu
x0 = x0+x1
t2 = x0
#     ********** determine an interval containing exactly
#                the desired eigenvalues **********
p = 1
q = n
m1 = m11-1
if (m1!=0) {
	isturm = 1
	go to 60
	}
repeat {
	m22 = m1+m
	if (m22!=n) {
		x0 = t2
		isturm = 2
		go to 60
		}
	repeat {
		q = 0
		r = 0
		repeat {
#     ********** establish and process next submatrix, refining
#                interval by the gerschgorin bounds **********
			if (r==m)
				go to 80
			tag = tag+1
			p = q+1
			xu = d(p)
			x0 = d(p)
			u = 0.0
#
			do q = p,n {
				x1 = u
				u = 0.0
				v = 0.0
				if (q!=n) {
					u = abs(e(q+1))
					v = e2(q+1)
					}
				xu = amin1(d(q)-(x1+u),xu)
				x0 = amax1(d(q)+(x1+u),x0)
				if (v==0.0)
					break 1
				}
#
			x1 = amax1(abs(xu),abs(x0))*PRECISION
			if (eps1<=0.0)
				eps1 = -x1
			if (p!=q) {
				x1 = x1*float(q-p+1)
				lb = amax1(t1,xu-x1)
				ub = amin1(t2,x0+x1)
				x1 = lb
				isturm = 3
				repeat {
#     ********** in-line procedure for sturm sequence **********
					s = p-1
					u = 1.0
#
					do i = p,q {
						if (u!=0.0)
							v = e2(i)/u
						else
							v = abs(e(i))/PRECISION
						u = d(i)-x1-v
						if (u<0.0)
							s = s+1
						}
#
					switch(isturm) {
						case 1:
							if (s<m1)
								go to 50
							if (s==m1)
								break 3
							go to 40
						case 2:
							if (s<m22)
								go to 50
							if (s==m22)
								break 2
							go to 40
						case 3:
							m1 = s+1
							x1 = ub
							isturm = 4
							next 1
						case 4:
							m2 = s
							if (m1>m2)
								go to 70
#     ********** find roots by bisection **********
							x0 = ub
							isturm = 5
#
							do i = m1,m2 {
								rv5(i) = ub
								rv4(i) = lb
								}
#     ********** loop for k-th eigenvalue
#                for k=m2 step -1 until m1 do --
#                (-do- not used to legalize computee-go-to) **********
							k = m2
						case 5:
#     ********** refine intervals **********
							if (s>=k)
								x0 = x1
							else {
								xu = x1
								if (s<m1)
									rv4(m1) = x1
								else {
									rv4(s+1) = x1
									if (rv5(s)>x1)
										rv5(s) = x1
									}
								}
							go to 30
						}
					repeat {
						xu = lb
#     ********** for i=k step -1 until m1 do -- **********
						do ii = m1,k {
							i = m1+k-ii
							if (xu<rv4(i))
								go to 10
							}
						go to 20
						10  xu = rv4(i)
#
						20  if (x0>rv5(k))
							x0 = rv5(k)
#     ********** next bisection step **********
						30  x1 = (xu+x0)*0.5
						if (x0-xu>2.0*PRECISION*(abs(xu)+abs(x0))+abs(eps1))
							next 2
#     ********** k-th eigenvalue found **********
						rv5(k) = x1
						k = k-1
						if (k<m1)
							break 2
						}
					40  x0 = x1
					go to 60
					50  xu = x1
					60  v = x1
					x1 = (xu+x0)*0.5
					if (x1==v)
						break 4
					}
				}
			else {
#     ********** check for isolated root within interval **********
				if (t1>d(p)||d(p)>=t2)
					go to 70
				m1 = p
				m2 = p
				rv5(p) = d(p)
				}
#     ********** order eigenvalues tagged with their
#                submatrix associations **********
			s = r
			r = r+m2-m1+1
			j = 1
			k = m1
#
			do l = 1,r {
				if (j<=s) {
					if (k>m2)
						break 1
					if (rv5(k)>=w(l)) {
						j = j+1
						next 1
						}
					else
#
						do ii = j,s {
							i = l+s-ii
							w(i+1) = w(i)
							ind(i+1) = ind(i)
							}
					}
#
				w(l) = rv5(k)
				ind(l) = tag
				k = k+1
				}
#
			70  if (q>=n)
				go to 80
			}
		t2 = x1
		}
	xu = x1
	t1 = x1
	}
#     ********** set error -- interval cannot be found containing
#                exactly the desired eigenvalues **********
ierr = 3*n+isturm
80  lb = t1
ub = t2
return
end



