#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include "S.h"
#include "y.tab.h"
#include "eval.h"
#include "options.h"

void S_terminate(), Recover(), Warning();
void add_error(), add_exit(), del_error(), do_C_stop();
int catchall();
char *sanity();
vector *Warn_list;
int last_signal, db_level = 0;
char error_buf[256];

static char *one_line();
static int S_terminating = 0;
static int Warn_max = 50;

void 
S_terminate(msg)
char *msg;
{
	if(S_terminating++)_exit(1); /* error in S_terminate: get out NOW */
	fputs("System terminating",stderr);
	if(msg && *msg)fprintf(stderr,": %s\n",msg);
	else fputs("\n",stderr);
 	if(runit_pid)kill(runit_pid,SIGKILL);
	if(audit_file)fflush(audit_file);
	fflush(stderr); fflush(stdout);
	exit(1);
}

char *
sanity(p,comment)
vector *p; char *comment;
{
	char *msg; extern int bad_header();
	if(p==NULL_ENTRY) msg="Null pointer not expected";
	else if(bad_header(p))
		msg=enci1("The value %ld is not likely to be a pointer",(long)p);
	else if(p->Type == FREED_TYPE)
		msg=encs1("tried to use freed vector of mode \"%s\"",token_name(data_mode(p)));
	else if(p->Type != ENTRY_TYPE)
		msg=enci2("overwritten vector? ( %ld, %ld..)\n",(long)p->Type,(long)p->mode);
	else if(p->length > p->nalloc)
		msg=enci2("length, %d, > allocated, %d\n",p->length,p->nalloc);
	else if(p->length < 0) msg=enci1("length== %ld",p->length);
	else return(NULL);
	if(comment==NULL_STRING)return(msg);
	Recover(encs2("Invalid internal object %s: %s",comment,msg),NULL);
#ifdef lint
	return(NULL);
#endif
}

void 
Recover(message, ent)
char *message; 
vector *ent;
{
	char *fname;
	db_level++; /* 1 unless there is an error in wrapup */
	/* level 2 error in wrapup; level 3 should cause terminate from do_stop
	/* only the truly bizarre can trigger the following -- */
	if(db_level>3)S_terminate("Infinite loop in error");
	if(ent!=NULL_ENTRY)sanity(ent,"expression in Recover");
	if(!Initialized){
		fprintf(stderr,"Terminating because of error in initialization or .First\n");
		S_terminate(message);
	}
	if(!last_signal) last_signal=SIGSERROR;
	if(message){
		fputs("Error",stderr);
		if((fname=cur_fun_name(cur_frame)))
			fprintf(stderr," in call to \"%s\": ",fname);
		else fputs(": ",stderr);
		fputs(message,stderr);
		if(!VOID(ent)){
			if(!LANGUAGE_TYPE(ent->mode))
				fprintf(stderr,": %s\n",short_dp(ent,(int)S_p_width));
			else {
				fputs(": ",stderr);
				deparse(ent,stderr);
			}
		}
		else fputs("\n",stderr);
	}
	if(Warn_list) {
		fprintf(stderr, "In addition: ");
		warn_message();
	}
	if(audit_file)fprintf(audit_file,"#~error: %s\n",one_line(message));
	do_stop(SIGSERROR); /* won't return */
}

void 
Warning(message,ent)
char *message; 
vector *ent;
{
	long prev;
	if(!Initialized) fprintf(stderr,"Warning: %s\n",message);
	if(warn_level<0) return;
	else if(warn_level>0) {
		if(warn_level>1) {
			message = encs1("(warning converted to error) %s\n",message);
			Recover(message,ent);
		}
		fprintf(stderr,"Warning: %s\n",message);
		if(ent){
			fputs("In: ",stderr);
			deparse(ent,stderr);
		}
		else if(cur_fun_name(cur_frame))
			fprintf(stderr,"  in call to %s\n",cur_fun_name(cur_frame));
		fflush(stderr);
		return;
	}
	prev = set_alloc(1L);
	if(Warn_list==NULL_ENTRY){
		Warn_list = alcvec(LIST,0L);
		Warn_list->name = "warnings";
	}
	if(Warn_list->length >= Warn_max)return;
	message = c_s_cpy(message);
	if(ent == NULL_ENTRY) ent = New_vector();
	else  ent = copy_data(ent,NULL_ENTRY);
	ent->name = message;
	append_el(Warn_list,(long)NOARG,ent);
	set_alloc(prev);
}


catchall(i)
int i;
{
	static struct unix_sigs{
		char *death;
		int is_terminal;
		} sigs[NSIG] ={
		"quit",TRUE,
		"illegal instruction",TRUE,
		"trace trap",TRUE,
		"iot",TRUE,
		"emt instr.",TRUE,
		"floating point exception",FALSE,
		"kill",FALSE,
		"bus error",TRUE,
		"bad address",TRUE,
		"bad system call",TRUE,
		"pipe error",FALSE,
		"alarm clock",FALSE,
		"software signal",FALSE,
		"user 1",FALSE,
		"user 2",FALSE,
		"child death",FALSE,
		"power fail",TRUE,
		};
	last_signal = i;
	if(i == 3 && Restart > 0) {
		Restart = 0;
		signal(i, catchall);
		fputs("Quit: restart cancelled\n", stderr);
		i = 2; /* treat as interrupt */
	}
	if(i == SIGPIPE && sinkpipe)
		set_stdout((FILE *)NULL);
	if(i>2 && i<20) { /* the signals I know about */
		signal(i,catchall);
		if(isatty(fileno(stdout)))fflush(stdout);
		if((sigs[i-3]).is_terminal) 
			S_terminate((sigs[i-3]).death);
		else Recover((sigs[i-3]).death,NULL_ENTRY);
	} else if(i==2) {
		signal(i,catchall);
		if(isatty(fileno(stdout)))fflush(stdout);
		fflush(stderr);
		if(audit_file)fputs("#~interrupt\n",audit_file);
		do_stop(SIGINT);
	} else exit(1); /*too weird to diagnose */
}

/* fortran-callable routine to cause abort -- use instead of stop */
F77_SUB(fabort) (msg) 
F_CHARTYPE msg;
{
	Recover(F_CHARP(msg), NULL_ENTRY);
}

/* following two classes of routines are equivalent -- should get rid of one*/
void 
add_error(fun)
fun_ptr fun;
{
	add_exit(fun,Nframe);
}

vector *C_wrapup;
void 
add_exit(fun,frame)
fun_ptr fun; long frame;
{
	vector *stop_list; long  vv[1], *nn, i, prev;
	if(frame!=PERM_FRAME){
if(check){
	if(frame<cur_frame)Warning(enci2("using storage frame %ld to set exit for frame %ld",
		cur_frame, frame), NULL_ENTRY);
}
		stop_list = C_on_stop->value.tree[frame-1];
		prev = frame<cur_frame ? set_alloc(frame) : cur_frame;
	}
	else {
		stop_list = C_wrapup;
		prev = (cur_frame == 1) ? 1 : set_alloc(1L);
	}
	if(VOID(stop_list)) {
		stop_list = alcvec(INT,0L);
		if(frame!=PERM_FRAME)C_on_stop->value.tree[Nframe-1] = stop_list;
		else C_wrapup = stop_list;
	}
	vv[0] = (long)fun;
	for(i=0, nn = stop_list->value.Long; i<stop_list->length; i++)
		if(nn[i]==vv[0]){i = -1; break;} /* already there */
	if(i>=0)append_data(stop_list,0L,1L,(char *)vv);
	if(prev!=cur_frame)set_alloc(prev);
}

void 
del_error(fun)
fun_ptr fun;
{
	long *p,n, cur = (long)fun; vector *stop_list;
	if(Nframe>C_on_stop->length)return;
	stop_list = C_on_stop->value.tree[Nframe-1];
	if(VOID(stop_list))return;
	for(n = 0, p = stop_list->value.Long; n<stop_list->length; n++, p++)
		if(cur == *p) {
			for(n++;n<stop_list->length;n++,p++)
				p[-1] = p[0];
			(stop_list->length)--;
			return;
		}
	Warning("C error code to be deleted wasn't set",NULL_ENTRY);
}

void 
do_C_stop(frame)
long frame;
{
	long n,*ll; fun_ptr p; vector *stop_list;
if(check) {
	if(frame<1 || frame > C_on_stop->length)Recover(enci1("Invalid frame number (%ld) given to do_C_stop",frame),NULL_ENTRY);
}
	stop_list = C_on_stop->value.tree[frame-1];
	if(VOID(stop_list))return;
	C_on_stop->value.tree[frame-1] = S_void;
	if(stop_list && stop_list->length) {
		n = stop_list->length; stop_list->length = 0L;
		ll = stop_list->value.Long+n-1;
		for(;n>0;n--,ll--) {
			p = ((fun_ptr)(*ll));
			if(*ll)(*p)();
		}
	}
}

void
do_C_wrap()
{
	long n,*ll; fun_ptr p;
	if(VOID(C_wrapup))return;
	if(C_wrapup && C_wrapup->length) {
		n = C_wrapup->length; C_wrapup->length = 0L;
		ll = C_wrapup->value.Long+n-1;
		for(;n>0;n--,ll--) {
			p = ((fun_ptr)(*ll));
			if(*ll)(*p)();
		}
	}
}

static char *
one_line(string)
char *string;
{
	char *pp = string, c;
	if(string == 0)
		return("");
	while(c = *pp++)
		if(c == '\n') {
			long n = pp - string-1;
			pp = S_alloc(n,1);
			strncpy(pp,string,(int)n-1);
			return(pp);
		}
	return(string);
}
