/* the interface between QPE and S */
#include <stdio.h>
#include "S.h"
#include "interface.h"
#include "eval.h"
#include "options.h"
#include "y.tab.h"

#define S_NA_PATTERN NA_PATTERN

#define Alcveq F77_SUB(alcveq)
#define Alcstx F77_SUB(alcstx)
#define Putel F77_SUB(putel)
#define Mkvec F77_SUB(mkvec)
#define S_ENTRY F77_SUB(gtenty)

/*codes for old-S interface routines */
#define ON_ERROR 1
#define ON_BREAK 2
#define PROBLEM_DONE 3
static fun_ptr last_S_entry;
static vector *QPE_fun();
static void old_S_error();

long 
QPE_to_S(ent)
vector *ent;
{
	int mode;
	long n, value, Alcveq (), Alcstx (), vec, *l, i, dir_ptr;
	double *d; char **s; float *f; vector **children, *child;
	char *encs1(), *token_name(), *name; long zero = 0, fptr;
if(check) {
	sanity(ent,"Object for conversion for S");
}
	mode = ent->mode; n = ent->length;
	switch(mode) {
	case LGL:
	case INT:
		fptr = F_PTR(ent->value.Long);
		return(Alcveq (&mode,&n,&fptr));
	case REAL:
		fptr = F_PTR((long *)ent->value.Float);
		return(Alcveq (&mode,&n,&fptr));
	case DOUBLE:
		mode = REAL;
		Mkvec (&mode,&n,&vec,&value);
		f = (float *)C_PTR(value);
		d = ent->value.Double;
		for(;n>0;n--,f++,d++)
			if(is_na(d)) *((long*) f) = S_NA_PATTERN;
			else *f = (float) *d;
		return(vec);
	case CHAR:
		Mkvec (&mode,&n,&vec,&value);
		l = C_PTR(value);
		s = ent->value.Char;
		while(n--) *l++ = F_CH_PTR( *s++ );
		return(vec);
	case STRUCTURE:
	case LIST:
		name = ent->name? ent->name: "";
		i = F_CH_PTR(name);
		vec = Alcstx (&n, &i); dir_ptr = S_VALUE_P(vec);
		children = ent->value.tree; i = 0;
		while(n--) {
			i++; child = *children++;
			name = child->name;
			if(name==NULL_STRING)name="";
			else if (*name == '.')name++;
			if(name_eq(name,"Dimnames")) name = "Label";
			value = QPE_to_S(child);
			S_NAME_P(value) = *name=='\0' ? 0 : F_CH_PTR(name);
			Putel (&dir_ptr, &i, &value);
		}
		return(vec);
	case MISSING:
	case NULL:
		Mkvec (&zero, &zero, &vec, &value);
		return(vec);
	default:
		PROBLEM "Can't pass data of mode \"%s\" to old-S function",
		  token_name(mode) RECOVER(NULL_ENTRY);
	}
#ifdef lint
	return(vec);	/* not reached */
#endif
}

vector *
S_to_QPE(p, level)
long p, level;
{
	long n, S_value;
	char **s, *name; long *l; int is_struct, mode;
	vector **children, *child; long S_ENTRY(), ei, i, j, name_ei;
	vector *value, *pp;
	if(p==0L)return(S_void);
	mode = S_MODE_P(p); n = S_LENGTH_P(p); S_value = S_VALUE_P(p);
	value = New_vector();
	value->mode = mode; value->length =value->nalloc = n;
	switch(mode) {
	case LGL:
	case INT:
		value->value.Long = C_PTR(S_value);
		qscan(value->value.Long,n,mode);
		break;
	case REAL:
		value->value.Float = (float *)C_PTR(S_value);
		qscan((long *)value->value.Float,n,mode);
		break;
	case CHAR:
		value = alcvec(CHAR,n); s = value->value.Char;
		l = C_PTR(S_value);
		while(n--) *s++ = C_CH_PTR( *l++ );
		break;
	case NULL:
		break;
	case STR:
		p = S_VALUE_P(p); n = S_LENGTH_P(p); i = 1;
		if(level==0 && n==1)return(S_to_QPE(S_ENTRY ( &p, &i ),0L));
		is_struct = FALSE;
		value = alcvec(LIST,n); children = value->value.tree;
		while(n--) {
			ei = S_ENTRY ( &p, &i ); name_ei = S_NAME_P( ei );
			child = S_to_QPE(ei,level+1);
			name = child->name = name_ei == 0 ? "" :
				C_CH_PTR( name_ei);
			if(name_eq(name,"Data")){
				is_struct = TRUE;
				child->name = ".Data";
			}
			else if(name_eq(name,"Dim")) child->name = ".Dim";
			else if(name_eq(name,"Tsp")){	/* convert to double */
				child->name = ".Tsp";
				pp = alcvec(DOUBLE,3L);
				for(j=0; j<3; j++) *(pp->value.Double+j) = *(child->value.Float+j);
				child->value = pp->value;
				child->mode = pp->mode;
			}
			else if(name_eq(name,"Label")){
				if(child->mode==CHAR) child->name = ".Label";
				else child->name = ".Dimnames";
				}
			*children++ = child; i++;
		}
		if(is_struct) value->mode = STRUCTURE;
	}
	return(value);
}

static int S_called = FALSE;
vector *
Sfun(call,sfun_ptr,frame)
vector *call,*sfun_ptr, *frame;
{
	vector *p, *pp;
	fun_ptr zthing; long F77_SUB(jstkst) ();
	char *fname;
	long instr, outstr, zero = 0;
	if(!S_called){
		F77_SUB(sqinit) ();
		S_called = TRUE;
	}
	switch(call->mode) {
	case FLEX_CALL:
		call = call->value.tree[0];
	case FUN_CALL:
		fname = (call->value.tree[0])->value.name; break;
	default:
		MEANINGFUL(fname);
		PROBLEM "Invalid call expression for old-S function" RECOVER(call);
	}
	if(sfun_ptr->length>0 || !(zthing = (fun_ptr) sfun_ptr->value.sys)){
		get_S_entry(sfun_ptr);
		zthing = last_S_entry;
	}
	if(!zthing)
		PROBLEM "old-S interface routine for \"%s\" is not in load table", fname RECOVER(NULL_ENTRY);
	frame->name = fname; instr = QPE_to_S(frame);
	p = alcvec(INT,1L); p->mode = S_DATA;
	instr = S_VALUE_P(instr);
	add_error((fun_ptr)old_S_error);
	outstr = (*zthing) (&instr);
	while( outstr && S_STYPE_P(outstr) == CHAINFUN) {
		pp = New_vector();
		pp->name = C_CH_PTR(S_SNAME_P(outstr)); pp->value.sys = NULL;
		get_S_entry(pp);
		zthing = last_S_entry;
		if(!zthing) {
			vector *get_data();
			if( get_data(fname,FUN_DEF) != NULL_ENTRY)
				return(QPE_fun(fname,outstr));
			else PROBLEM "old-S interface routine for \"%s\" is not in load table", fname RECOVER(NULL_ENTRY);
		}
		outstr = (*zthing) (&outstr);
	}
	del_error((fun_ptr)old_S_error);
	if(outstr == PROBLEM_DONE)PROBLEM "" RECOVER(NULL_ENTRY);	
	if(outstr == 0L || S_LENGTH_P(outstr)==0) {
		*(p->value.Long) = 0L;
		p->status |= NO_PRINT_BIT;
		}
	else{
		instr = Alcstx (&zero,&zero); S_VALUE_P(instr) = outstr;
		*(p->value.Long) = instr;
		if(S_STYPE_P(outstr)==S_NOPRINT)
			p->status |= NO_PRINT_BIT;
	}
	return(p);
}

static vector *
QPE_fun(name, instr)
char *name; long instr;
	/*call a QPE function as a chain from an S interface routine */
{
	vector *call, *S_to_QPE(), *alc_name(), *eval();
	call = S_to_QPE(instr, 0L);
	append_el(call,0L,alc_name(name));
	call->mode = FUN_CALL;
	return(eval(call));
}

vector *
get_S_entry(ent)
vector *ent;
{
	char *zname, *ftn_symbol(); fun_ptr get_entry(), zthing;
	switch(ent->mode) {
	case MISSING: case NULL:
		zname = ent->name;
		if((zthing = (fun_ptr) ent->value.sys)==NULL)
			zthing = get_entry(ftn_symbol(encs1("z%.5s",zname)));
		break;
	case CHAR:
		zname = ent->value.Char[0];
		zthing = get_entry(ftn_symbol(encs1("z%.5s",zname)));
		break;
	case NAME:
		zname = ent->value.name;
		zthing = get_entry(ftn_symbol(encs1("z%.5s",zname)));
		break;
	default:
		MEANINGFUL(zname); MEANINGFUL(zthing);
		PROBLEM "Invalid call to old-S function" RECOVER(ent);
	}
	last_S_entry = zthing;
	ent = New_vector();
	ent->value.sys = (vfun_ptr)zthing; ent->name = zname;
	return(ent);
}

static void 
old_S_error()
{
	long instr; extern int last_signal;
	instr = last_signal == 2 ? ON_BREAK : ON_ERROR;
	(*last_S_entry) (&instr);
}

/* Fortran stack interface to QPE stack allocation
 * no deallocation: storage is permanent or released when arena is released
 * jstkrl & jstkst are dummies
 */
extern char F77_COM(zcstkz) [];

long F77_SUB(getds)(Sname,pos)
long *Sname; long *pos;
{
	vector *p;
	char *name = C_CH_PTR(*Sname);
	UNUSED(pos);

	if(strcmp(name,"Random.seed")==0){
		long n = 12, *l;
		p = alcvec(INT,12L);
		l = p->value.Long; while(n--) *l++ = 0L;
	}
	else {
		/* the del_error() and add_error() here are to allow get_data()
		 * to quietly add its own (usual) error action to the error stack
		 */
		del_error((fun_ptr)old_S_error);
		p = get_data(name, ANY);
		add_error((fun_ptr)old_S_error);
		if(VOID(p))
			PROBLEM "Object \"%s\" not found", name RECOVER(NULL_ENTRY);
	}
	return QPE_to_S(p);
}

F77_SUB(putds)(Sname,entry,pos)
long *Sname; long *entry,*pos;
{
	char *encs1(), *name = C_CH_PTR(*Sname);
	UNUSED(pos); UNUSED(entry);

	if(strcmp(name,"Random.seed")!=0)
		PROBLEM "Attempting to write S object \"%s\"", name WARNING(NULL_ENTRY);
}

F77_SUB(cseedi)(i)
long *i;
{
	UNUSED(i); /* dummy */
}

F77_SUB(cseedo)(i)
long *i;
{
	UNUSED(i); /* dummy */
}

/* copy and convert QPE NAs into S-Style NAs */
F77_SUB(qcopy) (from, to, length, mode)
long  *from, *to, *length, *mode;
{
	long n = *length;
	UNUSED(mode);
	while(n--) {
		*to++ = is_na(from) ? S_NA_PATTERN :  *from;
		from++;
	}
}

/* scan data changing S-Style NAs into QPE NAs */

qscan(from, length, mode)
long  *from, length; int mode;
{
	long n = length;
	UNUSED(mode);
	while(n--) {
		if(*from == S_NA_PATTERN) na_set(from);
		from++;
	}
}

F77_SUB(zzabt) ()
/* error recovery from S functions */
	{ PROBLEM "" RECOVER(NULL_ENTRY); }
