FUNCTION approx(&)
STRUCTURE(x,y)
PLOTARGS
nx=LENGTH(x)
ARG(
	xout	/REAL,VECTOR,OPTIONAL/
	method	/CHAR,1,STRING(linear)/
	n	/INT,1,50/
	rule	/INT,1,1/
	size	/INT,1/
	)
STATIC( integer match,i; real dx )

if(LENGTH(x)!=LENGTH(y)) FATAL(Lengths of x and y must match)
if(LENGTH(x)<2)FATAL(need at least 2 points)
call sortpr(x,nx,y)
if(MISSING(size)){
	if(nx>20)size=nx/4.
	else size=max0(nx/2,2)
	}
if(MISSING(xout)){	# n evenly spaced points
	ALLOCATE(xout/REAL,n/)
	dx = (x[nx]-x[1])/float(max0(n-1,1))
	for(i=1; i<n; i=i+1) xout[i] = x[1]+(i-1)*dx
	xout[n] = x[nx]
	}
m=LENGTH(xout)
STRUCTURE(
	yout	/REAL,m/
	iscr	/INT,m/
	)

CTABLE(tabl,linear)	# later add spline, etc ...
i = match(method,tabl)
if(i<0)ABORT("Method ",C(TEXT(method))," is not available")
switch(i) {
case 1:call approx(x,y,nx,xout,m,rule,yout,iscr)
	}

RETURN(x=xout,y=yout)
END
