#crrs     crrs - get robust r**2 for regression
subroutine crrs(cres,y,wt,n,crsq)
#
real cres(1),wt(1),y(1)
#
#  sabl error flag
common/errcm/ierr
#
#  dynamic core storage
INCLUDE(stack)
#
#
#  get work space
i1 = jstkgt(n,2)
if (ierr!=2) {
	i2 = jstkgt(n,3)
	if (ierr==2)
#
#  error
		call jstkrl(1)
	else {
		i1m = i1-1
		i2m = i2-1
#
#  regress sorted fitted values on sorted weighted residuals
		call subt(y,cres,(n),rs(i2))
		call sort0(rs(i2),n)
		call bsorti(cres,(n),is(i1))
		xa = 0.
		xs = 0.
		do i = 1,n {
			i11i = i1m+i
			i21i = i2m+i
			nis = is(i11i)
			xa = xa+rs(i21i)*sqrt(wt(nis))
			xs = xs+sqrt(wt(i))
			}
		xa = xa/xs
#
		xs = 0.
		crsq = 0.
		do i = 1,n {
			i11i = i1m+i
			i21i = i2m+i
			nis = is(i11i)
			xs = xs+cres(i)*(rs(i21i)-xa)*wt(nis)
			crsq = crsq+wt(nis)*(rs(i21i)-xa)**2
			}
		crsq = xs/crsq
		crsq = 1./(1.+crsq**2)
#
#  reorder residuals
		call rmovf(cres,(n),rs(i2))
		do i = 1,n {
			i11i = i1m+i
			i21i = i2m+i
			nis = is(i11i)
			cres(nis) = rs(i21i)
			}
#
#  release work space
		call jstkrl(2)
		if (ierr!=2)
			return
		}
	}
continue
return
end



