FUNCTION tsmatrix(&)
STRUCTURE(x)
STATIC( real st,ed,pe; integer nr,nc )
nc=0
ALLARG(x)
	COERCE(x/TS,NAOK/)
	if(nc==0){
		pe=TNPER(x); st=TSTART(x); ed=TEND(x)
		}
	if(pe!=TNPER(x))FATAL(Time series have different periods)
	st=amax1(st,TSTART(x))
	ed=amin1(ed,TEND(x))
	nc=nc+1
NEXTARG

if(nc<1)FATAL(No data)
if(st>ed)FATAL(Non-intersecting series)
nr=(ed-st)*pe+1.5
STRUCTURE(
	y	/MATRIX,nr,nc/
	Tsp	/REAL,3/
	)
Tsp[1]=st; Tsp[2]=ed; Tsp[3]=pe

nc=0
ALLARG(x)
	COERCE(x/TS,NAOK/)
	i=(st-TSTART(x))*pe+.5
	call pcopy(VALUE(x)+i,VALUE(y)+nr*nc,nr,REAL)
	nc=nc+1
NEXTARG

INSERT(y,Tsp)	#add tsp to matrix
RETURN(y)
END
