INCLUDE(u/cstack)
/*  c-callable routine to write an S dataset directly to database */

cvint(name,data,n)
char *name; long data[]; long n;
{
	long mode = INT; long p;
	p = F_PTR(data);
	r_cvectr(name, &p, &n, &mode);
}

cvreal(name,data,n)
char *name; float data[]; long n;
{
	long mode = REAL; long p;
	p = F_PTR(((long *)data));
	r_cvectr(name, &p, &n, &mode);
}

cvchar(name,data,n)
char *name; char *data[]; long n;
{
	long mode = CHAR, *p, pp;
	char * calloc(); int i;
	p = (long *) calloc( (unsigned)n, sizeof *p );
	for(i=0; i<n; i++) p[i]=F_CH_PTR(data[i]);
	pp = F_PTR(p);
	r_cvectr(name, &pp, &n, &mode);
	free(p);
}

cmint(name,data,nrow,ncol)
char *name; long data[]; long nrow,ncol;
{
	long mode = INT; long p;
	p = F_PTR(data);
	r_cmatr(name, &p, &nrow, &ncol, &mode);
}

cmreal(name,data,nrow,ncol)
char *name; float data[]; long nrow,ncol;
{
	long mode = REAL; long p;
	p = F_PTR(((long *)data));
	r_cmatr(name, &p, &nrow, &ncol, &mode);
}

cmchar(name,data,nrow,ncol)
char *name; char *data[]; long nrow,ncol;
{
	long mode = CHAR, *p, pp, n;
	char * calloc(); int i;
	n = nrow*ncol;
	p = (long *) calloc( (unsigned)n, sizeof *p );
	for(i=0; i<n; i++) p[i]=F_CH_PTR(data[i]);
	pp = F_PTR(p);
	r_cmatr(name, &pp, &nrow, &ncol, &mode);
	free(p);
}

static	r_cvectr(name, p, n, mode)
char *name; long *p,*n,*mode;
{
	MAKES_F77_CHAR_CALL
	F77_CALL(cvectr,char=name,int=p,int=n,int=mode);
}

static	r_cmatr(name, data, n, p, mode)
char *name; long *data,*n,*p,*mode;
{
	MAKES_F77_CHAR_CALL
	F77_CALL(cmatr,char=name,int=data,int=n,int=p,int=mode);
}
