ROUTINE(betai,probability variable from beta less than x)
real function betai(x,pin,qin)
real x,pin,qin
# april 1977 version.  w. fullerton, c3, los alamos scientific lab.
# based on bosten and battiste, remark on algorithm 179, comm. acm,
# v 17, p 153, (1974).

#             input arguments --
# x      upper limit of integration.  x must be in (0,1) inclusive.
# p      first beta distribution parameter.  p must be gt 0.0.
# q      second beta distribution parameter.  q must be gt 0.0.
# betai  the incomplete beta function ratio is the probability that a
#        random variable from a beta distribution having parameters
#        p and q will be less than or equal to x.

real eps,alneps,sml,alnsml,y,p,q,albeta,ps,xb,term,c,p1,finsum
integer i,n,ib
SAVE( eps,alneps,sml,alnsml )
data eps,alneps,sml,alnsml/4*0.0/

if(x<0.0 | x>1.0) ERROR(x not in the range (0,1))
if(pin<=0.0 | qin<=0.0) ERROR(pin and/or qin less or equal zero)
if (eps==0.) {	# initialize
	eps = R1MACH(3)
	alneps = alog(eps)
	sml = R1MACH(1)
	alnsml = alog(sml)
	}

y = x
p = pin
q = qin
if (q>p||x>=0.8)
	if (x>=0.2) {
		y = 1.0-y
		p = qin
		q = pin
		}

if ((p+q)*y/(p+1.)<eps) {
	betai = 0.0
	xb = p*alog(amax1(y,sml))-alog(p)-albeta(p,q)
	if (xb>alnsml&&y!=0.)
		betai = exp(xb)
	if (y!=x||p!=pin)
		betai = 1.0-betai
	}
else {	# evaluate the infinite sum first.
# term will equal y**p/beta(ps,p) * (1.-ps)i * y**i / fac(i)
	ps = q-aint(q)
	if (ps==0.)
		ps = 1.0
	xb = p*alog(y)-albeta(ps,p)-alog(p)
	betai = 0.0
	if (xb>=alnsml) {
		betai = exp(xb)
		term = betai*p
		if (ps!=1.0) {
			n = amax1(alneps/alog(y),4.0)
			do i = 1,n {
				term = term*(float(i)-ps)*y/float(i)
				betai = betai+term/(p+float(i))
				}
			}
		}
# now evaluate the finite sum, maybe.
	if (q>1.0) {
		xb = p*alog(y)+q*alog(1.0-y)-albeta(p,q)-alog(q)
		ib = amax1(xb/alnsml,0.0)
		term = exp(xb-float(ib)*alnsml)
		c = 1.0/(1.0-y)
		p1 = q*c/(p+q-1.)
		finsum = 0.0
		n = q
		if (q==float(n))
			n = n-1
		do i = 1,n {
			if (p1<=1.0&&term/eps<=finsum)
				break 1
			term = (q-float(i-1))*c*term/(p+q-float(i))

			if (term>1.0){
				ib = ib-1
				term = term*sml
				}
			if (ib==0)
				finsum = finsum+term
			}

		betai = betai+finsum
		}
	if (y!=x||p!=pin)
		betai = 1.0-betai
	betai = amax1(amin1(betai,1.0),0.0)
	}
return
end
