ROUTINE(csevl,evaluate chebyshev series cs at x)
real function csevl(x,cs,n)
integer n
real x,cs(n)
# april 1977 version.  w. fullerton, c3, los alamos scientific lab.
# evaluate the n-term chebyshev series cs at x.  adapted from
# r. broucke, algorithm 446, c.a.c.m., 16, 254 (1973).  also see fox
# and parker, chebyshev polys in numerical analysis, oxford press, p.56.
#
#             input arguments --
# x      value at which the series is to be evaluated.
# cs     array of n terms of a chebyshev series.  in eval-
#        uating cs, only half the first coef is summed.
# n      number of terms in array cs.

real b0,b1,b2,twox; integer i,ni
if (n<1) ERROR(number of terms less or equal zero)
if (x<(-1.0)||x>1.0)  ERROR(x outside (-1,+1),result computed,WARNING)

b1 = 0.
b0 = 0.
twox = 2.*x
do i = 1,n {
	b2 = b1
	b1 = b0
	ni = n+1-i
	b0 = twox*b1-b2+cs(ni)
	}

return( 0.5*(b0-b2) )
end
