/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollBar;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.ScrollPaneConstants;
import com.sun.java.swing.Scrollable;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ScrollPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class JScrollPane
extends JComponent
implements ScrollPaneConstants,
Accessible {
    protected static final String[] cornerKeywords = new String[]{"LOWER_LEFT_CORNER", "LOWER_RIGHT_CORNER", "UPPER_LEFT_CORNER", "UPPER_RIGHT_CORNER"};
    private Border viewportBorder;

    public JScrollPane(Component component, int n, int n2) {
        this.updateUI();
        this.setViewport(this.createViewport());
        this.setViewportView(component);
        this.setVerticalScrollBarPolicy(n);
        this.setHorizontalScrollBarPolicy(n2);
    }

    public JScrollPane(Component component) {
        this(component, 20, 30);
    }

    public JScrollPane(int n, int n2) {
        this(null, n, n2);
    }

    public JScrollPane() {
        this(null, 20, 30);
    }

    public ScrollPaneUI getUI() {
        return (ScrollPaneUI)this.ui;
    }

    public void setUI(ScrollPaneUI scrollPaneUI) {
        super.setUI(scrollPaneUI);
    }

    public void updateUI() {
        Component component;
        int n;
        Integer n2;
        Integer n3;
        JViewport jViewport;
        JViewport jViewport2;
        JViewport jViewport3;
        if (this.ui != null) {
            jViewport3 = this.getViewport();
            jViewport2 = this.getRowHeader();
            jViewport = this.getColumnHeader();
            if (jViewport3 != null) {
                this.putClientProperty("VIEWPORT", jViewport3);
            }
            if (jViewport2 != null) {
                this.putClientProperty("ROW_HEADER", jViewport2);
            }
            if (jViewport != null) {
                this.putClientProperty("COLUMN_HEADER", jViewport);
            }
            n3 = new Integer(this.getVerticalScrollBarPolicy());
            n2 = new Integer(this.getHorizontalScrollBarPolicy());
            this.putClientProperty("VERTICAL_SCROLLBAR_POLICY", n3);
            this.putClientProperty("HORIZONTAL_SCROLLBAR_POLICY", n2);
            n = 0;
            while (n < cornerKeywords.length) {
                component = this.getCorner(cornerKeywords[n]);
                if (component != null) {
                    this.putClientProperty(cornerKeywords[n], component);
                }
                ++n;
            }
        }
        this.setUI((ScrollPaneUI)UIManager.getUI(this));
        if (this.ui != null) {
            jViewport3 = (JViewport)this.getClientProperty("VIEWPORT");
            jViewport2 = (JViewport)this.getClientProperty("ROW_HEADER");
            jViewport = (JViewport)this.getClientProperty("COLUMN_HEADER");
            n3 = (Integer)this.getClientProperty("VERTICAL_SCROLLBAR_POLICY");
            n2 = (Integer)this.getClientProperty("HORIZONTAL_SCROLLBAR_POLICY");
            if (n3 != null) {
                this.setVerticalScrollBarPolicy(n3);
            }
            if (n2 != null) {
                this.setHorizontalScrollBarPolicy(n2);
            }
            if (jViewport3 != null) {
                this.setViewport(jViewport3);
            }
            if (jViewport2 != null) {
                this.setRowHeader(jViewport2);
            }
            if (jViewport != null) {
                this.setColumnHeader(jViewport);
            }
            n = 0;
            while (n < cornerKeywords.length) {
                component = (Component)this.getClientProperty(cornerKeywords[n]);
                if (component != null) {
                    this.setCorner(cornerKeywords[n], component);
                } else {
                    this.setCorner(cornerKeywords[n], new 1());
                }
                ++n;
            }
        }
    }

    public String getUIClassID() {
        return "ScrollPaneUI";
    }

    public int getVerticalScrollBarPolicy() {
        return this.getUI().getVerticalScrollBarPolicy();
    }

    public void setVerticalScrollBarPolicy(int n) {
        if (n != this.getVerticalScrollBarPolicy()) {
            this.getUI().setVerticalScrollBarPolicy(n);
            this.invalidate();
        }
    }

    public int getHorizontalScrollBarPolicy() {
        return this.getUI().getHorizontalScrollBarPolicy();
    }

    public void setHorizontalScrollBarPolicy(int n) {
        if (n != this.getHorizontalScrollBarPolicy()) {
            this.getUI().setHorizontalScrollBarPolicy(n);
            this.invalidate();
        }
    }

    public Border getViewportBorder() {
        return this.viewportBorder;
    }

    public void setViewportBorder(Border border) {
        Border border2 = this.viewportBorder;
        this.viewportBorder = border;
        this.firePropertyChange("viewportBorder", border2, border);
    }

    public JScrollBar createHorizontalScrollBar() {
        return new ScrollBar(0);
    }

    public JScrollBar createVerticalScrollBar() {
        return new ScrollBar(1);
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.getUI().getHorizontalScrollBar();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.getUI().getVerticalScrollBar();
    }

    protected JViewport createViewport() {
        return new JViewport();
    }

    public JViewport getViewport() {
        return this.getUI().getViewport();
    }

    public void setViewport(JViewport jViewport) {
        if (jViewport != this.getViewport()) {
            this.getUI().setViewport(jViewport);
            this.invalidate();
            if (this.accessibleContext != null) {
                ((AccessibleJScrollPane)this.accessibleContext).resetViewPort();
            }
        }
    }

    public void setViewportView(Component component) {
        if (this.getViewport() == null) {
            this.setViewport(this.createViewport());
        }
        this.getViewport().setView(component);
    }

    public JViewport getRowHeader() {
        return this.getUI().getRowHeader();
    }

    public void setRowHeader(JViewport jViewport) {
        if (jViewport != this.getRowHeader()) {
            this.getUI().setRowHeader(jViewport);
            this.invalidate();
        }
    }

    public void setRowHeaderView(Component component) {
        if (this.getRowHeader() == null) {
            this.setRowHeader(this.createViewport());
        }
        this.getRowHeader().setView(component);
    }

    public JViewport getColumnHeader() {
        return this.getUI().getColumnHeader();
    }

    public void setColumnHeader(JViewport jViewport) {
        if (jViewport != this.getColumnHeader()) {
            this.getUI().setColumnHeader(jViewport);
            this.invalidate();
        }
    }

    public void setColumnHeaderView(Component component) {
        if (this.getColumnHeader() == null) {
            this.setColumnHeader(this.createViewport());
        }
        this.getColumnHeader().setView(component);
    }

    public Component getCorner(String string) {
        return this.getUI().getCorner(string);
    }

    public void setCorner(String string, Component component) {
        if (component != this.getCorner(string)) {
            this.getUI().setCorner(string, component);
            this.invalidate();
        }
    }

    public boolean isOpaque() {
        Component component;
        JViewport jViewport = this.getViewport();
        return jViewport != null && (component = jViewport.getView()) != null && component instanceof JComponent && ((JComponent)component).isOpaque() && ((JComponent)component).getWidth() >= jViewport.getWidth() && ((JComponent)component).getHeight() >= jViewport.getHeight();
    }

    public boolean isValidateRoot() {
        return true;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollPane();
        }
        return this.accessibleContext;
    }

    private final class 1
    extends JPanel {
        public void paint(Graphics graphics) {
            Color color = UIManager.getColor("control");
            graphics.setColor(color);
            graphics.fillRect(0, 0, this._bounds.width, this._bounds.height);
        }

        public boolean isOpaque() {
            return true;
        }

        /* synthetic */ 1() {
        }
    }

    protected class ScrollBar
    extends JScrollBar {
        public ScrollBar(int n) {
            super(n);
            JScrollPane.this = JScrollPane.this;
        }

        public int getUnitIncrement(int n) {
            JViewport jViewport = JScrollPane.this.getViewport();
            if (jViewport != null && jViewport.getView() instanceof Scrollable) {
                Scrollable scrollable = (Scrollable)((Object)jViewport.getView());
                Rectangle rectangle = jViewport.getViewRect();
                return scrollable.getScrollableUnitIncrement(rectangle, this.getOrientation(), n);
            }
            return super.getUnitIncrement(n);
        }

        public int getBlockIncrement(int n) {
            JViewport jViewport = JScrollPane.this.getViewport();
            if (jViewport == null) {
                return super.getBlockIncrement(n);
            }
            if (jViewport.getView() instanceof Scrollable) {
                Scrollable scrollable = (Scrollable)((Object)jViewport.getView());
                Rectangle rectangle = jViewport.getViewRect();
                return scrollable.getScrollableBlockIncrement(rectangle, this.getOrientation(), n);
            }
            if (this.getOrientation() == 1) {
                return jViewport.getExtentSize().width;
            }
            return jViewport.getExtentSize().height;
        }
    }

    protected class AccessibleJScrollPane
    extends JComponent.AccessibleJComponent
    implements ChangeListener {
        protected JViewport viewPort;

        public void resetViewPort() {
            this.viewPort.removeChangeListener(this);
            this.viewPort = JScrollPane.this.getViewport();
            this.viewPort.addChangeListener(this);
        }

        public AccessibleJScrollPane() {
            JScrollPane.this = JScrollPane.this;
            if (this.viewPort == null) {
                this.viewPort = JScrollPane.this.getViewport();
            }
            this.viewPort.addChangeListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AccessibleContext accessibleContext = JScrollPane.this.getAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
            }
        }
    }
}

