/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
PropertyChangeListener,
Serializable {
    private Rectangle tmpRect = new Rectangle();
    private KeyStroke altPressedKeyStroke;
    private KeyStroke altReleasedKeyStroke;
    private KeyStroke nonAltReleasedKeyStroke;
    private static KeyStroke spacePressedKeyStroke = null;
    private static KeyStroke spaceReleasedKeyStroke = null;

    public BasicButtonListener(AbstractButton abstractButton) {
        if (spacePressedKeyStroke == null) {
            spacePressedKeyStroke = KeyStroke.getKeyStroke(32, 0, false);
            spaceReleasedKeyStroke = KeyStroke.getKeyStroke(32, 0, true);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("MnemonicChanged")) {
            this.uninstallKeyboardActions((AbstractButton)propertyChangeEvent.getSource());
            this.installKeyboardActions((AbstractButton)propertyChangeEvent.getSource());
        }
    }

    public void installKeyboardActions(AbstractButton abstractButton) {
        PressedAction pressedAction = new PressedAction(abstractButton);
        ReleasedAction releasedAction = new ReleasedAction(abstractButton);
        abstractButton.registerKeyboardAction(pressedAction, spacePressedKeyStroke, 0);
        abstractButton.registerKeyboardAction(releasedAction, spaceReleasedKeyStroke, 0);
        int n = abstractButton.getMnemonic();
        if (n != 0) {
            this.altPressedKeyStroke = KeyStroke.getKeyStroke(n, 8, false);
            this.altReleasedKeyStroke = KeyStroke.getKeyStroke(n, 8, true);
            this.nonAltReleasedKeyStroke = KeyStroke.getKeyStroke(n, 0, true);
            abstractButton.registerKeyboardAction(pressedAction, this.altPressedKeyStroke, 2);
            abstractButton.registerKeyboardAction(releasedAction, this.altReleasedKeyStroke, 2);
            abstractButton.registerKeyboardAction(releasedAction, this.nonAltReleasedKeyStroke, 2);
        }
    }

    public void uninstallKeyboardActions(AbstractButton abstractButton) {
        if (spacePressedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(spacePressedKeyStroke);
        }
        if (spaceReleasedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(spaceReleasedKeyStroke);
        }
        if (this.altPressedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(this.altPressedKeyStroke);
            this.altPressedKeyStroke = null;
        }
        if (this.altReleasedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(this.altReleasedKeyStroke);
            this.altReleasedKeyStroke = null;
        }
        if (this.nonAltReleasedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(this.nonAltReleasedKeyStroke);
            this.nonAltReleasedKeyStroke = null;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
        abstractButton.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
        JRootPane jRootPane;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        if (abstractButton instanceof JButton && (jRootPane = abstractButton.getRootPane()) != null) {
            jRootPane.setDefaultButton((JButton)abstractButton);
        }
        abstractButton.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        abstractButton.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed()) {
            this.tmpRect.width = abstractButton.getWidth();
            this.tmpRect.height = abstractButton.getHeight();
            if (this.tmpRect.contains(mouseEvent.getPoint())) {
                buttonModel.setArmed(true);
                return;
            }
            buttonModel.setArmed(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
            if (!abstractButton.hasFocus()) {
                abstractButton.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        buttonModel.setPressed(false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        if (abstractButton.isRolloverEnabled()) {
            abstractButton.getModel().setRollover(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        if (abstractButton.isRolloverEnabled()) {
            abstractButton.getModel().setRollover(false);
        }
    }

    static class PressedAction
    extends AbstractAction {
        AbstractButton b;

        PressedAction(AbstractButton abstractButton) {
            super("pressedAction");
            this.b = abstractButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ButtonModel buttonModel = this.b.getModel();
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
            if (!this.b.hasFocus()) {
                this.b.requestFocus();
            }
        }

        public boolean isEnabled() {
            return this.b.getModel().isEnabled();
        }
    }

    static class ReleasedAction
    extends AbstractAction {
        AbstractButton b;

        ReleasedAction(AbstractButton abstractButton) {
            super("releasedAction");
            this.b = abstractButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.b.getModel().setPressed(false);
        }

        public boolean isEnabled() {
            return this.b.getModel().isEnabled();
        }
    }
}

