/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.MenuSelectionManager;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.MenuItemUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.basic.BasicMenuMouseListener;
import com.sun.java.swing.plaf.basic.BasicMenuMouseMotionListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class BasicMenuItemUI
extends MenuItemUI
implements Serializable {
    protected static Color pressedBackground;
    protected static Color pressedForeground;
    protected static final int defaultTextIconGap = 4;
    protected MouseListener mouseListener;
    protected MouseMotionListener dragListener;
    protected Icon menuArrow;
    protected Icon checkIcon;
    protected boolean oldBorderPainted;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuItemUI();
    }

    public void installUI(JComponent jComponent) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        this.initListeners(jComponent);
        this.addListeners(jComponent);
        jComponent.setOpaque(true);
        LookAndFeel.installBorder(jComponent, "MenuItem.border");
        this.oldBorderPainted = jMenuItem.isBorderPainted();
        jMenuItem.setBorderPainted((Boolean)UIManager.get("MenuItem.borderPainted"));
        LookAndFeel.installColorsAndFont(jComponent, "MenuItem.background", "MenuItem.foreground", "MenuItem.font");
        if (pressedBackground == null || pressedBackground instanceof UIResource) {
            pressedBackground = UIManager.getColor("MenuItem.pressedBackground");
        }
        if (pressedForeground == null || pressedForeground instanceof UIResource) {
            pressedForeground = UIManager.getColor("MenuItem.pressedForeground");
        }
        if (this.menuArrow == null || this.menuArrow instanceof UIResource) {
            this.menuArrow = UIManager.getIcon("MenuItem.arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon("MenuItem.checkIcon");
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.removeListeners(jComponent);
        LookAndFeel.uninstallBorder(jComponent);
        ((JMenuItem)jComponent).setBorderPainted(this.oldBorderPainted);
        if (this.menuArrow instanceof UIResource) {
            this.menuArrow = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void initListeners(JComponent jComponent) {
        this.mouseListener = this.createMouseListener(jComponent);
        this.dragListener = this.createMouseMotionListener(jComponent);
    }

    protected void addListeners(JComponent jComponent) {
        jComponent.addMouseListener(this.mouseListener);
        jComponent.addMouseMotionListener(this.dragListener);
    }

    protected void removeListeners(JComponent jComponent) {
        jComponent.removeMouseListener(this.mouseListener);
        jComponent.removeMouseMotionListener(this.dragListener);
    }

    protected MouseListener createMouseListener(JComponent jComponent) {
        return new BasicMenuMouseListener();
    }

    protected MouseMotionListener createMouseMotionListener(JComponent jComponent) {
        return new BasicMenuMouseMotionListener();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Icon icon = this.getCheckIcon();
        Icon icon2 = this.getMenuArrow();
        return BasicGraphicsUtils.getPreferredMenuItemSize(jComponent, icon, icon2, 4);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        BasicGraphicsUtils.paintMenuItem(graphics, jComponent, this.getCheckIcon(), this.getMenuArrow(), pressedBackground, pressedForeground, 4);
    }

    public Insets getDefaultMargin(AbstractButton abstractButton) {
        return new Insets(2, 2, 2, 2);
    }

    Icon getMenuArrow() {
        return this.menuArrow;
    }

    Icon getCheckIcon() {
        return this.checkIcon;
    }

    public void processMouseEvent(JMenuItem jMenuItem, MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        Point point = mouseEvent.getPoint();
        if (point.x >= 0 && point.x < jMenuItem.getWidth() && point.y >= 0 && point.y < jMenuItem.getHeight()) {
            if (mouseEvent.getID() == 502) {
                menuSelectionManager.clearSelectedPath();
                jMenuItem.doClick(0);
                return;
            }
            menuSelectionManager.setSelectedPath(menuElementArray);
            return;
        }
        if (mouseEvent.getID() == 502) {
            menuSelectionManager.clearSelectedPath();
            return;
        }
        if (jMenuItem.getModel().isArmed()) {
            MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
            int n = 0;
            int n2 = menuElementArray.length - 1;
            while (n < n2) {
                menuElementArray2[n] = menuElementArray[n];
                ++n;
            }
            menuSelectionManager.setSelectedPath(menuElementArray2);
        }
    }

    private int lower(int n) {
        if (n >= 65 && n <= 90) {
            return n + 97 - 65;
        }
        return n;
    }

    public void processKeyEvent(JMenuItem jMenuItem, KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        int n = jMenuItem.getMnemonic();
        if (n == 0) {
            return;
        }
        if (keyEvent.getID() == 401 && this.lower(n) == this.lower(keyEvent.getKeyChar())) {
            menuSelectionManager.clearSelectedPath();
            jMenuItem.doClick(0);
            keyEvent.consume();
        }
    }
}

