/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JSlider;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.Timer;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.SliderUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;

public class BasicSliderUI
extends SliderUI
implements Serializable,
PropertyChangeListener {
    public final int POSITIVE_SCROLL = 1;
    public final int NEGATIVE_SCROLL = -1;
    public final int MIN_SCROLL = -2;
    public final int MAX_SCROLL = 2;
    protected ScrollListener scrollListener;
    protected Timer scrollTimer;
    protected JSlider slider;
    protected Rectangle labelRect = new Rectangle(0, 0, 0, 0);
    protected int trackBuffer;
    private static final int TICK_SPACE = 8;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(164, 21);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(21, 164);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 21);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(21, 36);
    private transient boolean isDragging;
    private TrackListener trackListener;
    private ModelListener modelListener;
    private SizingListener sizeListener;
    private FListener focusListener;
    private Rectangle thumbRect = new Rectangle(0, 0, 0, 0);
    private Color shadowColor;
    private Color highlightColor;
    private Color focusColor;

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSliderUI((JSlider)jComponent);
    }

    public BasicSliderUI(JSlider jSlider) {
    }

    public void installUI(JComponent jComponent) {
        this.slider = (JSlider)jComponent;
        LookAndFeel.installBorder(this.slider, "Slider.border");
        LookAndFeel.installColors(this.slider, "Slider.background", "Slider.foreground");
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.isDragging = false;
        this.trackListener = new TrackListener();
        this.modelListener = new ModelListener();
        this.sizeListener = new SizingListener();
        this.focusListener = new FListener();
        this.scrollListener = new ScrollListener();
        this.scrollTimer = new Timer(100, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
        this.slider.addMouseListener(this.trackListener);
        this.slider.addMouseMotionListener(this.trackListener);
        this.slider.addFocusListener(this.focusListener);
        this.slider.addComponentListener(this.sizeListener);
        this.slider.addPropertyChangeListener(this);
        this.slider.getModel().addChangeListener(this.modelListener);
        this.slider.setEnabled(this.slider.isEnabled());
        this.slider.setOpaque(true);
        this.calculateThumbBounds();
        this.recalcLabelRect();
        this.recalcTrackBuffer();
        this.calculateThumbBounds();
        this.slider.registerKeyboardAction(new ActionScroller(this.slider, 1, false), KeyStroke.getKeyStroke(39, 0), 0);
        this.slider.registerKeyboardAction(new ActionScroller(this.slider, -1, false), KeyStroke.getKeyStroke(40, 0), 0);
        this.slider.registerKeyboardAction(new ActionScroller(this.slider, -1, true), KeyStroke.getKeyStroke(34, 0), 0);
        this.slider.registerKeyboardAction(new ActionScroller(this.slider, -1, false), KeyStroke.getKeyStroke(37, 0), 0);
        this.slider.registerKeyboardAction(new ActionScroller(this.slider, 1, false), KeyStroke.getKeyStroke(38, 0), 0);
        this.slider.registerKeyboardAction(new ActionScroller(this.slider, 1, true), KeyStroke.getKeyStroke(33, 0), 0);
        this.slider.registerKeyboardAction(new ActionScroller(this.slider, -2, true), KeyStroke.getKeyStroke(36, 0), 0);
        this.slider.registerKeyboardAction(new ActionScroller(this.slider, 2, true), KeyStroke.getKeyStroke(35, 0), 0);
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.slider) {
            throw new IllegalComponentStateException(String.valueOf(this) + " was asked to deinstall() " + jComponent + " when it only knows about " + this.slider + ".");
        }
        LookAndFeel.uninstallBorder(this.slider);
        this.scrollTimer.stop();
        this.scrollTimer = null;
        this.slider.getModel().removeChangeListener(this.modelListener);
        this.slider.removeMouseListener(this.trackListener);
        this.slider.removeMouseMotionListener(this.trackListener);
        this.slider.removeFocusListener(this.focusListener);
        this.slider.removeComponentListener(this.sizeListener);
        this.slider.removePropertyChangeListener(this);
        this.slider.resetKeyboardActions();
        this.thumbRect = null;
        this.slider = null;
    }

    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        if (this.slider.getOrientation() == 1) {
            dimension = new Dimension(this.getPreferredVerticalSize());
            if (this.slider.getPaintTicks()) {
                dimension.width += this.getScrollTickRect().width + 1;
            }
            if (this.slider.getPaintLabels()) {
                dimension.width += this.getLabelRect().width + 1;
            }
        } else {
            dimension = new Dimension(this.getPreferredHorizontalSize());
            if (this.slider.getPaintTicks()) {
                dimension.height += this.getScrollTickRect().height + 1;
            }
            if (this.slider.getPaintLabels()) {
                dimension.height += this.getLabelRect().height + 1;
            }
        }
        dimension.width += this.slider.getInsets().left + this.slider.getInsets().right;
        dimension.height += this.slider.getInsets().top + this.slider.getInsets().bottom;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        if (this.slider.getOrientation() == 1) {
            dimension = new Dimension(this.getMinimumVerticalSize());
            if (this.slider.getPaintTicks()) {
                dimension.width += this.getTickSpace() + 1;
            }
            if (this.slider.getPaintLabels()) {
                dimension.width += this.getLabelRect().width + 1;
            }
        } else {
            dimension = new Dimension(this.getMinimumHorizontalSize());
            if (this.slider.getPaintTicks()) {
                dimension.height += this.getTickSpace() + 1;
            }
            if (this.slider.getPaintLabels()) {
                dimension.height += this.getLabelRect().height + 1;
            }
        }
        dimension.width += this.slider.getInsets().left + this.slider.getInsets().right;
        dimension.height += this.slider.getInsets().top + this.slider.getInsets().bottom;
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (this.slider.getOrientation() == 1) {
            dimension.height = Short.MAX_VALUE;
        } else {
            dimension.width = Short.MAX_VALUE;
        }
        return dimension;
    }

    protected Rectangle getFullContentArea() {
        Rectangle rectangle = new Rectangle();
        Insets insets = this.slider.getInsets();
        Dimension dimension = this.slider.getSize();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = dimension.width - (insets.left + insets.right);
        rectangle.height = dimension.height - (insets.top + insets.bottom);
        return rectangle;
    }

    public Rectangle getScrollTrackRect() {
        Rectangle rectangle = this.getFullContentArea();
        if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 0) {
                rectangle.setSize(rectangle.width, this.getScrollTickRect().y - 1 - rectangle.y);
            } else {
                rectangle.setSize(this.getScrollTickRect().x - 1 - rectangle.x, rectangle.height);
            }
        }
        return rectangle;
    }

    public Rectangle getScrollTickRect() {
        Rectangle rectangle = this.getFullContentArea();
        if (this.slider.getPaintTicks()) {
            Rectangle rectangle2 = this.getLabelRect();
            if (this.slider.getOrientation() == 1) {
                if (this.slider.getPaintLabels()) {
                    rectangle.setLocation(rectangle2.x - 1 - this.getTickSize(), rectangle.y);
                } else {
                    rectangle.setLocation(rectangle.x + (rectangle.width - 1) - this.getTickSize(), rectangle.y);
                }
                rectangle.setSize(this.getTickSize(), rectangle.height);
            } else {
                if (this.slider.getPaintLabels()) {
                    rectangle.setLocation(rectangle.x, rectangle2.y - 1 - this.getTickSize());
                } else {
                    rectangle.setLocation(rectangle.x, rectangle.y + (rectangle.height - 1) - this.getTickSize());
                }
                rectangle.setSize(rectangle.width, this.getTickSize());
            }
        } else {
            rectangle.setLocation(this.labelRect.x, this.labelRect.y);
            if (this.slider.getOrientation() == 1) {
                rectangle.setSize(0, rectangle.height);
            } else {
                rectangle.setSize(rectangle.width, 0);
            }
        }
        return rectangle;
    }

    public Rectangle getLabelRect() {
        return this.labelRect;
    }

    protected void recalcLabelRect() {
        Rectangle rectangle = this.getFullContentArea();
        if (this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 0) {
                int n = this.getHeightOfTallestLabel();
                rectangle.y = rectangle.y + (rectangle.height - 1) - n;
                rectangle.height = n;
            } else {
                int n = this.getWidthOfWidestLabel();
                rectangle.x = rectangle.x + (rectangle.width - 1) - n;
                rectangle.width = n;
            }
        } else if (this.slider.getOrientation() == 1) {
            rectangle.setLocation(rectangle.x + (rectangle.width - 1), rectangle.y);
            rectangle.setSize(0, rectangle.height);
        } else {
            rectangle.setLocation(rectangle.x, rectangle.y + (rectangle.height - 1));
            rectangle.setSize(rectangle.width, 0);
        }
        this.labelRect = rectangle;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("labelTable")) {
            this.recalcLabelRect();
            this.recalcTrackBuffer();
        }
    }

    protected void recalcTrackBuffer() {
        if (this.slider.getPaintLabels() && this.slider.getLabelTable() != null) {
            Component component = this.getHighestValueLabel();
            Component component2 = this.getLowestValueLabel();
            if (this.slider.getOrientation() == 0) {
                this.trackBuffer = Math.max(component.getBounds().width, component2.getBounds().width) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.getThumbRect().width / 2);
                return;
            }
            this.trackBuffer = Math.max(component.getBounds().height, component2.getBounds().height) / 2;
            this.trackBuffer = Math.max(this.trackBuffer, this.getThumbRect().height / 2);
            return;
        }
        if (this.slider.getOrientation() == 0) {
            this.trackBuffer = this.getThumbRect().width / 2;
            return;
        }
        this.trackBuffer = this.getThumbRect().height / 2;
    }

    protected int getWidthOfWidestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n = Math.max(component.getPreferredSize().width, n);
            }
        }
        return n;
    }

    protected int getHeightOfTallestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n = Math.max(component.getPreferredSize().height, n);
            }
        }
        return n;
    }

    protected int getWidthOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected int getWidthOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected int getHeightOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().height;
        }
        return n;
    }

    protected int getHeightOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().height;
        }
        return n;
    }

    protected Component getLowestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n2 = (Integer)enumeration.nextElement();
                n = Math.min(n2, n);
            }
            component = (Component)dictionary.get(new Integer(n));
        }
        return component;
    }

    protected Component getHighestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n2 = (Integer)enumeration.nextElement();
                n = Math.max(n2, n);
            }
            component = (Component)dictionary.get(new Integer(n));
        }
        return component;
    }

    public int getTickSpace() {
        return 8;
    }

    public int getTickSize() {
        return this.getTickSpace();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintTrack(graphics);
        if (this.slider.getPaintTicks()) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels()) {
            this.paintLabels(graphics);
        }
        this.paintFocus(graphics);
        this.paintThumb(graphics);
    }

    public void paintFocus(Graphics graphics) {
        if (this.slider.hasFocus()) {
            Rectangle rectangle = this.slider.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            if (this.slider.getBorder() != null) {
                rectangle = this.getFullContentArea();
            }
            graphics.setColor(this.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        }
    }

    public void paintTrack(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle = this.getScrollTrackRect();
        if (this.slider.getOrientation() == 0) {
            int n3;
            n2 = n3 = this.trackBuffer;
            n = rectangle.height / 2 - 2;
            int n4 = rectangle.width - this.trackBuffer * 2;
            graphics.translate(rectangle.x + n2, rectangle.y + n);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, 0, n4 - 1, 0);
            graphics.drawLine(0, 1, 0, 2);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(0, 3, n4, 3);
            graphics.drawLine(n4, 0, n4, 3);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, n4 - 2, 1);
        } else {
            int n5 = this.trackBuffer;
            n2 = rectangle.width / 2 - 2;
            n = n5;
            int n6 = rectangle.height - this.trackBuffer * 2;
            graphics.translate(rectangle.x + n2, rectangle.y + n);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, 0, 0, n6 - 1);
            graphics.drawLine(1, 0, 2, 0);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(3, 0, 3, n6);
            graphics.drawLine(0, n6, 3, n6);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, 1, n6 - 2);
        }
        graphics.translate(-(rectangle.x + n2), -(rectangle.y + n));
    }

    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.getScrollTickRect();
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(this.slider.getBackground());
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        int n = this.slider.getMajorTickSpacing();
        int n2 = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            int n3 = this.slider.getMinimum();
            int n4 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                while (n3 <= this.slider.getMaximum()) {
                    n4 = this.xPositionForValue(n3);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n4);
                    n3 += this.slider.getMinorTickSpacing();
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n3 = this.slider.getMinimum();
                while (n3 <= this.slider.getMaximum()) {
                    n4 = this.xPositionForValue(n3);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n4);
                    n3 += this.slider.getMajorTickSpacing();
                }
            }
        } else {
            int n5 = this.slider.getMinimum();
            int n6 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                while (n5 <= this.slider.getMaximum()) {
                    n6 = this.yPositionForValue(n5);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n6);
                    n5 += this.slider.getMinorTickSpacing();
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n5 = this.slider.getMinimum();
                while (n5 <= this.slider.getMaximum()) {
                    n6 = this.yPositionForValue(n5);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n6);
                    n5 += this.slider.getMajorTickSpacing();
                }
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width / 2 - 1, n);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width - 2, n);
    }

    public void paintLabels(Graphics graphics) {
        Rectangle rectangle = this.getLabelRect();
        graphics.translate(rectangle.x, rectangle.y);
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                Component component = (Component)dictionary.get(n);
                if (this.slider.getOrientation() == 0) {
                    this.paintHorizontalLabel(graphics, n, component);
                    continue;
                }
                this.paintVerticalLabel(graphics, n, component);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void paintHorizontalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.xPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().width / 2;
        graphics.translate(n3, 0);
        component.paint(graphics);
        graphics.translate(-n3, 0);
    }

    protected void paintVerticalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.yPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().height / 2;
        graphics.translate(0, n3);
        component.paint(graphics);
        graphics.translate(0, -n3);
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.getThumbRect();
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.isEnabled()) {
            graphics.setColor(this.slider.getBackground());
        } else {
            graphics.setColor(this.slider.getBackground().darker());
        }
        if (!this.slider.getPaintTicks()) {
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(Color.black);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.setColor(BasicGraphicsUtils.controlHighlight);
            graphics.drawLine(0, 0, 0, n2 - 2);
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.setColor(BasicGraphicsUtils.controlShadow);
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
        } else if (this.slider.getOrientation() == 0) {
            int n3 = n / 2;
            graphics.fillRect(1, 1, n - 3, n2 - 1 - n3);
            Polygon polygon = new Polygon();
            polygon.addPoint(1, n2 - n3);
            polygon.addPoint(n3 - 1, n2 - 1);
            polygon.addPoint(n - 2, n2 - 1 - n3);
            graphics.fillPolygon(polygon);
            graphics.setColor(BasicGraphicsUtils.controlHighlight);
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(0, 1, 0, n2 - 1 - n3);
            graphics.drawLine(0, n2 - n3, n3 - 1, n2 - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 2 - n3);
            graphics.drawLine(n - 1, n2 - 1 - n3, n - 1 - n3, n2 - 1);
            graphics.setColor(BasicGraphicsUtils.controlShadow);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 2 - n3);
            graphics.drawLine(n - 2, n2 - 1 - n3, n - 1 - n3, n2 - 2);
        } else {
            int n4 = n2 / 2;
            graphics.fillRect(1, 1, n - 1 - n4, n2 - 3);
            Polygon polygon = new Polygon();
            polygon.addPoint(n - n4 - 1, 0);
            polygon.addPoint(n - 1, n4);
            polygon.addPoint(n - 1 - n4, n2 - 2);
            graphics.fillPolygon(polygon);
            graphics.setColor(BasicGraphicsUtils.controlHighlight);
            graphics.drawLine(0, 0, 0, n2 - 2);
            graphics.drawLine(1, 0, n - 1 - n4, 0);
            graphics.drawLine(n - n4 - 1, 0, n - 1, n4);
            graphics.setColor(Color.black);
            graphics.drawLine(0, n2 - 1, n - 2 - n4, n2 - 1);
            graphics.drawLine(n - 1 - n4, n2 - 1, n - 1, n2 - 1 - n4);
            graphics.setColor(BasicGraphicsUtils.controlShadow);
            graphics.drawLine(1, n2 - 2, n - 2 - n4, n2 - 2);
            graphics.drawLine(n - 1 - n4, n2 - 2, n - 2, n2 - n4 - 1);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void setThumbBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
        this.thumbRect.setBounds(n, n2, n3, n4);
        Rectangle rectangle2 = rectangle.union(this.thumbRect);
        this.slider.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public void setThumbLocation(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
        this.thumbRect.setLocation(n, n2);
        Rectangle rectangle2 = rectangle.union(this.thumbRect);
        this.slider.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public Rectangle getThumbRect() {
        return this.thumbRect;
    }

    public void scrollByBlock(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = this.slider.getValue();
            int n3 = this.slider.getMaximum() / 10;
            int n4 = n3 * (n > 0 ? 1 : -1);
            this.slider.setValue(n2 + n4);
            return;
        }
    }

    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = this.slider.getValue();
            int n3 = n > 0 ? 1 : -1;
            this.slider.setValue(n2 + n3);
            return;
        }
    }

    protected void scrollDueToClickInTrack(int n) {
        this.scrollByBlock(n);
    }

    protected int xPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        this.slider.getMaximum();
        Rectangle rectangle = this.getScrollTrackRect();
        int n4 = rectangle.width - this.trackBuffer * 2;
        int n5 = this.slider.getMaximum() - this.slider.getMinimum();
        double d = (double)n4 / (double)n5;
        int n6 = rectangle.x + this.trackBuffer;
        int n7 = rectangle.x + (rectangle.width - 1) - this.trackBuffer;
        if (!this.slider.getInverted()) {
            n2 = n6;
            n2 = (int)((long)n2 + Math.round(d * (double)(n - n3)));
        } else {
            n2 = n7;
            n2 = (int)((long)n2 - Math.round(d * (double)(n - n3)));
        }
        n2 = Math.max(n6, n2);
        n2 = Math.min(n7, n2);
        return n2;
    }

    protected int yPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        Rectangle rectangle = this.getScrollTrackRect();
        int n5 = rectangle.height - this.trackBuffer * 2;
        int n6 = this.slider.getMaximum() - this.slider.getMinimum();
        double d = (double)n5 / (double)n6;
        int n7 = rectangle.y + this.trackBuffer;
        int n8 = rectangle.y + (rectangle.height - 1) - this.trackBuffer;
        if (!this.slider.getInverted()) {
            n2 = n7;
            n2 = (int)((long)n2 + Math.round(d * (double)(n4 - n)));
        } else {
            n2 = n7;
            n2 = (int)((long)n2 + Math.round(d * (double)(n - n3)));
        }
        n2 = Math.max(n7, n2);
        n2 = Math.min(n8, n2);
        return n2;
    }

    public void calculateThumbBounds() {
        if (this.slider.getOrientation() == 1) {
            this.setThumbBounds(this.getScrollTrackRect().x, this.yPositionForValue(this.slider.getValue()) - this.getThumbRect().height / 2, this.getScrollTrackRect().width, 11);
            return;
        }
        this.setThumbBounds(this.xPositionForValue(this.slider.getValue()) - this.getThumbRect().width / 2, this.getScrollTrackRect().y, 11, this.getScrollTrackRect().height);
    }

    protected class ModelListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            if (!BasicSliderUI.this.isDragging) {
                BasicSliderUI.this.calculateThumbBounds();
            }
        }

        ModelListener() {
            BasicSliderUI.this = BasicSliderUI.this;
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            BasicSliderUI.this.scrollTimer.stop();
            if (BasicSliderUI.this.slider.getSnapToTicks()) {
                BasicSliderUI.this.isDragging = false;
                BasicSliderUI.this.slider.setValueIsAdjusting(false);
                return;
            }
            BasicSliderUI.this.slider.setValueIsAdjusting(false);
            BasicSliderUI.this.isDragging = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            BasicSliderUI.this.slider.requestFocus();
            if (BasicSliderUI.this.getThumbRect().contains(this.currentMouseX, this.currentMouseY)) {
                switch (BasicSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - BasicSliderUI.this.getThumbRect().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - BasicSliderUI.this.getThumbRect().x;
                        break;
                    }
                }
                BasicSliderUI.this.isDragging = true;
                BasicSliderUI.this.slider.setValueIsAdjusting(true);
                return;
            }
            BasicSliderUI.this.isDragging = false;
            BasicSliderUI.this.slider.setValueIsAdjusting(true);
            Dimension dimension = BasicSliderUI.this.slider.getSize();
            int n = 1;
            switch (BasicSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2;
                    if (BasicSliderUI.this.getThumbRect().isEmpty()) {
                        n2 = dimension.height / 2;
                        if (!BasicSliderUI.this.slider.getInverted()) {
                            n = this.currentMouseY < n2 ? 1 : -1;
                            break;
                        }
                        n = this.currentMouseY < n2 ? -1 : 1;
                        break;
                    }
                    n2 = BasicSliderUI.this.getThumbRect().y;
                    if (!BasicSliderUI.this.slider.getInverted()) {
                        n = this.currentMouseY < n2 ? 1 : -1;
                        break;
                    }
                    n = this.currentMouseY < n2 ? -1 : 1;
                    break;
                }
                case 0: {
                    int n2;
                    if (BasicSliderUI.this.getThumbRect().isEmpty()) {
                        n2 = dimension.width / 2;
                        if (!BasicSliderUI.this.slider.getInverted()) {
                            n = this.currentMouseX < n2 ? -1 : 1;
                            break;
                        }
                        n = this.currentMouseX < n2 ? 1 : -1;
                        break;
                    }
                    n2 = BasicSliderUI.this.getThumbRect().x;
                    if (!BasicSliderUI.this.slider.getInverted()) {
                        n = this.currentMouseX < n2 ? -1 : 1;
                        break;
                    }
                    n = this.currentMouseX < n2 ? 1 : -1;
                    break;
                }
            }
            BasicSliderUI.this.scrollDueToClickInTrack(n);
            Rectangle rectangle = BasicSliderUI.this.getThumbRect();
            if (!rectangle.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(n)) {
                BasicSliderUI.this.scrollTimer.stop();
                BasicSliderUI.this.scrollListener.setDirection(n);
                BasicSliderUI.this.scrollTimer.start();
            }
        }

        /*
         * Exception decompiling
         */
        public boolean shouldScroll(int var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Inconsistent graph @DISABLED, blocks:[] lbl11 : ReturnValueStatement: return false;\u000a does not have a source @NONE, blocks:[] lbl10 : Nop: NOP
             * 
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner$1.call(Cleaner.java:49)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner$1.call(Cleaner.java:22)
             *     at org.benf.cfr.reader.util.graph.GraphVisitorDFS.process(GraphVisitorDFS.java:68)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner.removeUnreachableCode(Cleaner.java:54)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:648)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle = BasicSliderUI.this.getScrollTrackRect();
            int n = 0;
            if (!BasicSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!BasicSliderUI.this.isDragging) {
                return;
            }
            switch (BasicSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = BasicSliderUI.this.getThumbRect().height / 2;
                    int n3 = mouseEvent.getY() - this.offset;
                    int n4 = rectangle.y + BasicSliderUI.this.trackBuffer;
                    int n5 = rectangle.y + (rectangle.height - 1) - BasicSliderUI.this.trackBuffer;
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    BasicSliderUI.this.setThumbLocation(BasicSliderUI.this.getThumbRect().x, n3);
                    n = n3 + n2;
                    BasicSliderUI.this.slider.setValue(this.valueForYPosition(n));
                    return;
                }
                case 0: {
                    int n6 = BasicSliderUI.this.getThumbRect().width / 2;
                    int n7 = mouseEvent.getX() - this.offset;
                    int n8 = rectangle.x + BasicSliderUI.this.trackBuffer;
                    int n9 = rectangle.x + (rectangle.width - 1) - BasicSliderUI.this.trackBuffer;
                    n7 = Math.max(n7, n8 - n6);
                    n7 = Math.min(n7, n9 - n6);
                    BasicSliderUI.this.setThumbLocation(n7, BasicSliderUI.this.getThumbRect().y);
                    n = n7 + n6;
                    BasicSliderUI.this.slider.setValue(this.valueForXPosition(n));
                    return;
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public int valueForYPosition(int n) {
            int n2;
            int n3 = BasicSliderUI.this.slider.getMinimum();
            int n4 = BasicSliderUI.this.slider.getMaximum();
            Rectangle rectangle = BasicSliderUI.this.getScrollTrackRect();
            int n5 = rectangle.height - BasicSliderUI.this.trackBuffer * 2;
            int n6 = rectangle.y + BasicSliderUI.this.trackBuffer;
            int n7 = rectangle.y + (rectangle.height - 1) - BasicSliderUI.this.trackBuffer;
            if (n <= n6) {
                n2 = BasicSliderUI.this.slider.getInverted() ? n3 : n4;
            } else if (n >= n7) {
                n2 = BasicSliderUI.this.slider.getInverted() ? n4 : n3;
            } else {
                int n8 = n - n6;
                int n9 = n4 - n3;
                double d = (double)n9 / (double)n5;
                int n10 = (int)Math.round((double)n8 * d);
                n2 = BasicSliderUI.this.slider.getInverted() ? n3 + n10 : n4 - n10;
            }
            return n2;
        }

        public int valueForXPosition(int n) {
            int n2;
            int n3 = BasicSliderUI.this.slider.getMinimum();
            int n4 = BasicSliderUI.this.slider.getMaximum();
            Rectangle rectangle = BasicSliderUI.this.getScrollTrackRect();
            int n5 = rectangle.width - BasicSliderUI.this.trackBuffer * 2;
            int n6 = rectangle.x + BasicSliderUI.this.trackBuffer;
            int n7 = rectangle.x + (rectangle.width - 1) - BasicSliderUI.this.trackBuffer;
            if (n <= n6) {
                n2 = BasicSliderUI.this.slider.getInverted() ? n4 : n3;
            } else if (n >= n7) {
                n2 = BasicSliderUI.this.slider.getInverted() ? n3 : n4;
            } else {
                int n8 = n - n6;
                int n9 = n4 - n3;
                double d = (double)n9 / (double)n5;
                int n10 = (int)Math.round((double)n8 * d);
                n2 = BasicSliderUI.this.slider.getInverted() ? n4 - n10 : n3 + n10;
            }
            return n2;
        }

        TrackListener() {
            BasicSliderUI.this = BasicSliderUI.this;
        }
    }

    public class ScrollListener
    implements ActionListener,
    Serializable {
        int direction = 1;
        boolean useBlockIncrement;

        public ScrollListener() {
            BasicSliderUI.this = BasicSliderUI.this;
            this.direction = 1;
            this.useBlockIncrement = true;
        }

        public ScrollListener(int n, boolean bl) {
            BasicSliderUI.this = BasicSliderUI.this;
            this.direction = n;
            this.useBlockIncrement = bl;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.useBlockIncrement = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                BasicSliderUI.this.scrollByBlock(this.direction);
            } else {
                BasicSliderUI.this.scrollByUnit(this.direction);
            }
            if (!BasicSliderUI.this.trackListener.shouldScroll(this.direction)) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    protected class SizingListener
    implements ComponentListener,
    Serializable {
        public void componentResized(ComponentEvent componentEvent) {
            BasicSliderUI.this.recalcLabelRect();
            BasicSliderUI.this.calculateThumbBounds();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            BasicSliderUI.this.recalcLabelRect();
            BasicSliderUI.this.calculateThumbBounds();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            BasicSliderUI.this.recalcLabelRect();
            BasicSliderUI.this.calculateThumbBounds();
        }

        public void componentShown(ComponentEvent componentEvent) {
            BasicSliderUI.this.recalcLabelRect();
            BasicSliderUI.this.calculateThumbBounds();
        }

        SizingListener() {
            BasicSliderUI.this = BasicSliderUI.this;
        }
    }

    protected class FListener
    implements FocusListener,
    Serializable {
        public void focusGained(FocusEvent focusEvent) {
            BasicSliderUI.this.slider.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicSliderUI.this.slider.repaint();
        }

        FListener() {
            BasicSliderUI.this = BasicSliderUI.this;
        }
    }

    protected class ActionScroller
    extends AbstractAction
    implements Serializable {
        int dir;
        boolean block;
        JSlider slider;

        public ActionScroller(JSlider jSlider, int n, boolean bl) {
            BasicSliderUI.this = BasicSliderUI.this;
            this.dir = n;
            this.block = bl;
            this.slider = jSlider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.slider.isEnabled()) {
                if (this.dir == -1 || this.dir == 1) {
                    int n = this.dir;
                    if (this.slider.getInverted()) {
                        int n2 = n = this.dir == -1 ? 1 : -1;
                    }
                    if (this.block) {
                        BasicSliderUI.this.scrollByBlock(n);
                        return;
                    }
                    BasicSliderUI.this.scrollByUnit(n);
                    return;
                }
                if (this.slider.getInverted()) {
                    if (this.dir == -2) {
                        this.slider.setValue(this.slider.getMaximum());
                        return;
                    }
                    if (this.dir == 2) {
                        this.slider.setValue(this.slider.getMinimum());
                        return;
                    }
                } else {
                    if (this.dir == -2) {
                        this.slider.setValue(this.slider.getMinimum());
                        return;
                    }
                    if (this.dir == 2) {
                        this.slider.setValue(this.slider.getMaximum());
                    }
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

