/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.preview.filechooser;

import com.sun.java.swing.preview.filechooser.FileSystemView;
import java.io.File;
import java.io.IOException;

class UnixFileSystemView
extends FileSystemView {
    public boolean isRoot(File file) {
        String string = file.getAbsolutePath();
        return string.length() == 1 && string.charAt(0) == '/';
    }

    public File createNewFolder(File file) throws IOException {
        if (file == null) {
            throw new IOException("Containing directory is null:");
        }
        File file2 = null;
        file2 = this.createFileObject(file, "NewFolder");
        int n = 1;
        while (file2.exists() && n < 100) {
            file2 = this.createFileObject(file, "NewFolder." + n);
            ++n;
        }
        if (file2.exists()) {
            throw new IOException("Directory already exists:" + file2.getAbsolutePath());
        }
        file2.mkdirs();
        return file2;
    }

    public boolean isHiddenFile(File file) {
        if (file != null) {
            String string = file.getName();
            return string.charAt(0) == '.';
        }
        return false;
    }

    public File[] getRoots() {
        File[] fileArray = new File[]{new File("/")};
        if (fileArray[0].exists() && fileArray[0].isDirectory()) {
            return fileArray;
        }
        return null;
    }

    UnixFileSystemView() {
    }
}

