/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.CompositeView;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class BoxView
extends CompositeView {
    int axis;
    int width;
    int height;
    boolean xValid;
    boolean yValid;
    int[] preferredSpan = new int[2];
    int[] resizeWeight = new int[2];
    float[] alignment = new float[2];
    boolean xAllocValid;
    int[] xOffsets;
    int[] xSpans;
    boolean yAllocValid;
    int[] yOffsets;
    int[] ySpans;

    public BoxView(Element element, int n) {
        super(element);
        this.axis = n;
    }

    protected void paintChild(Graphics graphics, Rectangle rectangle, int n) {
        View view = this.getView(n);
        view.paint(graphics, rectangle);
    }

    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        this.xOffsets = null;
        this.xSpans = null;
        this.xValid = false;
        this.xAllocValid = false;
        this.yOffsets = null;
        this.ySpans = null;
        this.yValid = false;
        this.yAllocValid = false;
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (bl) {
            this.xValid = false;
            this.xAllocValid = false;
        }
        if (bl2) {
            this.yValid = false;
            this.yAllocValid = false;
        }
        super.preferenceChanged(view, bl, bl2);
    }

    public void setSize(float f, float f2) {
        if ((int)f != this.width) {
            this.xAllocValid = false;
        }
        if ((int)f2 != this.height) {
            this.yAllocValid = false;
        }
        if (!this.xAllocValid || !this.yAllocValid) {
            this.width = (int)f;
            this.height = (int)f2;
            this.layout(this.width - this.getLeftInset() - this.getRightInset(), this.height - this.getTopInset() - this.getBottomInset());
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.setSize(rectangle.width, rectangle.height);
        int n = this.getViewCount();
        int n2 = rectangle.x + this.getLeftInset();
        int n3 = rectangle.y + this.getTopInset();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n4 = 0;
        while (n4 < n) {
            rectangle.x = n2 + this.xOffsets[n4];
            rectangle.y = n3 + this.yOffsets[n4];
            rectangle.width = this.xSpans[n4];
            rectangle.height = this.ySpans[n4];
            if (rectangle.intersects(rectangle2)) {
                this.paintChild(graphics, rectangle, n4);
            }
            ++n4;
        }
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.modelToView(n, shape);
    }

    public int viewToModel(float f, float f2, Shape shape) {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.viewToModel(f, f2, shape);
    }

    public float getAlignment(int n) {
        this.checkRequests();
        switch (n) {
            case 0: 
            case 1: {
                return this.alignment[n];
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public int getResizeWeight(int n) {
        this.checkRequests();
        switch (n) {
            case 0: 
            case 1: {
                return this.resizeWeight[n];
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getPreferredSpan(int n) {
        this.checkRequests();
        switch (n) {
            case 0: {
                return this.preferredSpan[n] + this.getLeftInset() + this.getRightInset();
            }
            case 1: {
                return this.preferredSpan[n] + this.getTopInset() + this.getBottomInset();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        Element[] elementArray;
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            object = new View[elementArray2.length];
            int n = 0;
            while (n < elementArray2.length) {
                object[n] = viewFactory.create(elementArray2[n]);
                ++n;
            }
            this.replace(elementChange.getIndex(), elementArray.length, (View[])object);
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        elementArray = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        object = this.getViewAtPosition(n, (Rectangle)elementArray);
        if (object != null) {
            ((View)object).insertUpdate(documentEvent, (Shape)elementArray, viewFactory);
            if (((View)object).getStartOffset() == n && n > 0) {
                object = this.getViewAtPosition(n - 1, (Rectangle)elementArray);
                ((View)object).insertUpdate(documentEvent, (Shape)elementArray, viewFactory);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        Element[] elementArray;
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        boolean bl = true;
        if (elementChange != null) {
            elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            object = new View[elementArray2.length];
            int n = 0;
            while (n < elementArray2.length) {
                object[n] = viewFactory.create(elementArray2[n]);
                ++n;
            }
            this.replace(elementChange.getIndex(), elementArray.length, (View[])object);
            if (((Object)object).length != 0) {
                bl = false;
            }
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        if (bl) {
            elementArray = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
            int n = documentEvent.getOffset();
            object = this.getViewAtPosition(n, (Rectangle)elementArray);
            if (object != null) {
                ((View)object).removeUpdate(documentEvent, (Shape)elementArray, viewFactory);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        Object object2;
        Element element = this.getElement();
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (rectangle != null) {
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.width;
            n4 = rectangle.height;
        }
        int n5 = element.getElementIndex(documentEvent.getOffset());
        int n6 = element.getElementIndex(documentEvent.getOffset() + Math.max(documentEvent.getLength() - 1, 0));
        int n7 = n5;
        while (n7 <= n6) {
            object2 = this.getView(n7);
            if (rectangle != null) {
                rectangle.x = n + this.xOffsets[n7];
                rectangle.y = n2 + this.yOffsets[n7];
                rectangle.width = this.xSpans[n7];
                rectangle.height = this.ySpans[n7];
            }
            ((View)object2).changedUpdate(documentEvent, rectangle, viewFactory);
            ++n7;
        }
        object2 = documentEvent.getChange(element);
        if (object2 != null) {
            object = object2.getChildrenRemoved();
            Element[] elementArray = object2.getChildrenAdded();
            View[] viewArray = new View[elementArray.length];
            int n8 = 0;
            while (n8 < elementArray.length) {
                viewArray[n8] = viewFactory.create(elementArray[n8]);
                ++n8;
            }
            this.replace(object2.getIndex(), ((Object)object).length, viewArray);
        }
        if (shape != null && !this.isAllocationValid()) {
            object = this.getContainer();
            ((Component)object).repaint(n, n2, n3, n4);
        }
    }

    protected boolean isAllocationValid() {
        return this.xAllocValid && this.yAllocValid;
    }

    protected boolean isBefore(int n, int n2, Rectangle rectangle) {
        if (this.axis == 0) {
            return n < rectangle.x;
        }
        return n2 < rectangle.y;
    }

    protected boolean isAfter(int n, int n2, Rectangle rectangle) {
        if (this.axis == 0) {
            return n > rectangle.width + rectangle.x;
        }
        return n2 > rectangle.height + rectangle.y;
    }

    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        int n3 = this.getViewCount();
        if (this.axis == 0) {
            if (n < rectangle.x + this.xOffsets[0]) {
                this.childAllocation(0, rectangle);
                return this.getView(0);
            }
            int n4 = 0;
            while (n4 < n3) {
                if (n < rectangle.x + this.xOffsets[n4]) {
                    this.childAllocation(n4 - 1, rectangle);
                    return this.getView(n4 - 1);
                }
                ++n4;
            }
            this.childAllocation(n3 - 1, rectangle);
            return this.getView(n3 - 1);
        }
        if (n2 < rectangle.y + this.yOffsets[0]) {
            this.childAllocation(0, rectangle);
            return this.getView(0);
        }
        int n5 = 0;
        while (n5 < n3) {
            if (n2 < rectangle.y + this.yOffsets[n5]) {
                this.childAllocation(n5 - 1, rectangle);
                return this.getView(n5 - 1);
            }
            ++n5;
        }
        this.childAllocation(n3 - 1, rectangle);
        return this.getView(n3 - 1);
    }

    protected void childAllocation(int n, Rectangle rectangle) {
        rectangle.x += this.xOffsets[n];
        rectangle.y += this.yOffsets[n];
        rectangle.width = this.xSpans[n];
        rectangle.height = this.ySpans[n];
    }

    protected void layout(int n, int n2) {
        int n3;
        this.checkRequests();
        if (this.xSpans == null) {
            n3 = this.getViewCount();
            this.xSpans = new int[n3];
            this.ySpans = new int[n3];
            this.xOffsets = new int[n3];
            this.yOffsets = new int[n3];
        }
        if (this.axis == 0) {
            if (!this.xAllocValid) {
                this.calculateTiledPositions(n, 0);
            }
            if (!this.yAllocValid) {
                this.calculateAlignedPositions(n2, 1);
            }
        } else {
            if (!this.xAllocValid) {
                this.calculateAlignedPositions(n, 0);
            }
            if (!this.yAllocValid) {
                this.calculateTiledPositions(n2, 1);
            }
        }
        this.xAllocValid = true;
        this.yAllocValid = true;
        n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getView(n4);
            view.setSize(this.xSpans[n4], this.ySpans[n4]);
            ++n4;
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    void checkRequests() {
        if (this.axis == 0) {
            if (!this.xValid) {
                this.calculateTiledSizeRequirements(0);
            }
            if (!this.yValid) {
                this.calculateAlignedSizeRequirements(1);
            }
        } else {
            if (!this.xValid) {
                this.calculateAlignedSizeRequirements(0);
            }
            if (!this.yValid) {
                this.calculateTiledSizeRequirements(1);
            }
        }
        this.yValid = true;
        this.xValid = true;
    }

    void calculateTiledSizeRequirements(int n) {
        this.alignment[n] = 0.5f;
        this.preferredSpan[n] = 0;
        this.resizeWeight[n] = 0;
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getView(n3);
            int n4 = n;
            this.preferredSpan[n4] = (int)((float)this.preferredSpan[n4] + view.getPreferredSpan(n));
            int n5 = n;
            this.resizeWeight[n5] = this.resizeWeight[n5] + view.getResizeWeight(n);
            ++n3;
        }
    }

    void calculateAlignedSizeRequirements(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getViewCount();
        int n5 = 0;
        while (n5 < n4) {
            View view = this.getView(n5);
            int n6 = (int)view.getPreferredSpan(n);
            int n7 = (int)(view.getAlignment(n) * (float)n6);
            int n8 = n6 - n7;
            n2 = Math.max(n8, n2);
            n3 = Math.max(n7, n3);
            int n9 = n;
            this.resizeWeight[n9] = this.resizeWeight[n9] + view.getResizeWeight(n);
            ++n5;
        }
        this.preferredSpan[n] = n2 + n3;
        this.alignment[n] = 0.5f;
        if (this.preferredSpan[n] > 0) {
            this.alignment[n] = (float)n3 / (float)this.preferredSpan[n];
        }
    }

    void calculateAlignedPositions(int n, int n2) {
        int[] nArray = n2 == 0 ? this.xOffsets : this.yOffsets;
        int[] nArray2 = n2 == 0 ? this.xSpans : this.ySpans;
        int n3 = (int)((float)n * this.alignment[n2]);
        int n4 = n - n3;
        int n5 = this.getViewCount();
        int n6 = 0;
        while (n6 < n5) {
            View view = this.getView(n6);
            float f = view.getAlignment(n2);
            int n7 = (int)view.getPreferredSpan(n2);
            int n8 = (int)((float)n7 * f);
            int n9 = n7 - n8;
            if (view.getResizeWeight(n2) > 0) {
                n8 = n3;
                n9 = n4;
            }
            nArray[n6] = n3 - n8;
            nArray2[n6] = n8 + n9;
            ++n6;
        }
    }

    void calculateTiledPositions(int n, int n2) {
        int[] nArray = n2 == 0 ? this.xOffsets : this.yOffsets;
        int[] nArray2 = n2 == 0 ? this.xSpans : this.ySpans;
        int n3 = n - this.preferredSpan[n2];
        int n4 = this.resizeWeight[n2];
        int n5 = 0;
        int n6 = this.getViewCount();
        int n7 = 0;
        while (n7 < n6) {
            View view = this.getView(n7);
            nArray[n7] = n5;
            int n8 = (int)view.getPreferredSpan(n2);
            int n9 = view.getResizeWeight(n2);
            if (n9 != 0 && n4 != 0) {
                float f = n9 / n4;
                n8 = (int)((float)n8 + (float)n3 * f);
            }
            nArray2[n7] = n8;
            n5 += n8;
            ++n7;
        }
    }
}

