/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class ComponentView
extends View {
    private Component c;

    public ComponentView(Element element) {
        super(element);
        AttributeSet attributeSet = element.getAttributes();
        this.c = StyleConstants.getComponent(attributeSet);
        this.c.setVisible(false);
    }

    public void paint(Graphics graphics, Shape shape) {
        this.c.setBounds(shape.getBounds());
        if (!this.c.isVisible()) {
            this.c.setVisible(true);
        }
    }

    public float getPreferredSpan(int n) {
        Dimension dimension = this.c.getPreferredSize();
        switch (n) {
            case 0: {
                return dimension.width;
            }
            case 1: {
                return dimension.height;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 0: {
                return this.c.getAlignmentX();
            }
            case 1: {
                return this.c.getAlignmentY();
            }
        }
        return super.getAlignment(n);
    }

    public void setSize(float f, float f2) {
        this.c.setSize((int)f, (int)f2);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view == null) {
            Container container = this.c.getParent();
            container.remove(this.c);
            return;
        }
        Container container = this.getContainer();
        container.add(this.c);
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n < n3) {
            Rectangle rectangle = new Rectangle(shape.getBounds());
            rectangle.width = 0;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f, float f2, Shape shape) {
        return this.getStartOffset();
    }
}

