#include <stdio.h>
#include <X11/Xlib.h>   
#include <X11/Xutil.h>	
#include <X11/Xos.h>
/*  Hey look!  it's an array...  and it looks incredibly like a bitmap... */

#define web_width 16
#define web_height 16
static char web_bits[] = {
   0x00, 0x00, 0x02, 0x81, 0x94, 0x53, 0x6a, 0xad, 0x14, 0x51, 0x24, 0x49,
   0x44, 0x45, 0x82, 0x83, 0xfe, 0xff, 0x82, 0x83, 0x44, 0x45, 0x24, 0x49,
   0x14, 0x51, 0x6a, 0xad, 0x94, 0x53, 0x02, 0x81};



int topx=0, incr=1;
Pixmap stipple;

main(argc, argv)
int argc;
char *argv[];
{

  /* there are a few X variables that are needed..  lots of these are not 
   * needed to make just a plain window, but they are required to have frills.. 
   * Like XFontStruct is necessary for fonts (text)...
   */

  Window window,rootwindow;
  Display *display;
  GC gc, gc2,pixmapgc ;
  XGCValues gcvalues;
  XEvent xevent;
  XConfigureEvent *configureevent;
  XButtonPressedEvent *buttonpressed;
  int screen,width=100 , height=100;
  int lookupstring;
  char buffer[2];
  int counter;
  unsigned int button;
  XFontStruct *font;
  XRectangle rectangle;
  Region region;

  if((display = XOpenDisplay(NULL))==NULL) {  /*try to open up a display */
    fprintf(stderr, "cannot connect to X server %s \n", XDisplayName(NULL));
    exit(-1);
  }

  /* set up screen, display, window */
  screen=DefaultScreen(display); /* get :0.0  <= last 0 */
  rootwindow = RootWindow(display,screen); /*get parent window id */
  window=XCreateSimpleWindow(display,rootwindow,100,100,220,220,3,
		 WhitePixel(display,screen), BlackPixel(display,screen));


  /* Get the graphic contexts */
  gcvalues.function=GXinvert;
  gcvalues.foreground=WhitePixel(display, screen);
  gcvalues.background=BlackPixel(display, screen);

  gc2 = XCreateGC(display, window, 
		  (GCForeground|GCBackground|GCFunction), &gcvalues); 
  gc = XCreateGC(display, window, 
		 (GCBackground|GCForeground), &gcvalues); 

  if((stipple=XCreateBitmapFromData(display, window, web_bits, web_width, web_height)) == NULL) fprintf(stderr,"Couldn't show internal pixmap\n");


  /* get font */
  if ((font=XLoadQueryFont(display, "9x15"))==NULL) {
    fprintf(stderr,"can't load 9x15 font\n");
    exit(-1);
  }


  XStoreName(display,window, "My first window");
  XSetIconName(display, window, "Window name");

  XSelectInput(display, window, ExposureMask | ButtonPressMask
	       | StructureNotifyMask |KeyPressMask);

  
  
  XMapWindow(display,window);

  XFlush(display);
  while(1){ 
    XNextEvent(display, &xevent );
    switch(xevent.type) {
    case ConfigureNotify:
      width=xevent.xconfigure.width;
      height=xevent.xconfigure.height;
      break;
    case KeyPress:
      lookupstring = XLookupString(&xevent.xkey, buffer, 2, NULL, NULL);
      for(counter=0;counter<lookupstring; counter++) {
	printf("%c\n",buffer[counter]);
	printf("ascii code = %d \n",buffer[counter]);
	printf("\n");
      }
      newline(display, window,gc2, height, width);
      if(buffer[counter]==17) exit(0);
      break;
    case ButtonPress:
      buttonpressed=(XButtonPressedEvent *) &xevent;
      
      printf("Button pressed is: %d \n", buttonpressed->button);
      newline(display, window,gc2, height, width);
      break;
    case Expose:
      region=XCreateRegion();
      do {
	rectangle.x=(short) xevent.xexpose.x;
	rectangle.y=(short) xevent.xexpose.y;
	rectangle.width=(unsigned short) xevent.xexpose.width;
	rectangle.height=(unsigned short) xevent.xexpose.height;
	XUnionRectWithRegion(&rectangle, region, region);
	
      } while (XCheckTypedEvent(display, Expose, &xevent));
      XSetRegion(display, gc, region);

      Drawpixmap(display, window,gc,width, height);
      
      redraw(display, window, gc,height, width);

      write_something(display, window, gc, height, width,font );
      XDestroyRegion(region);
      break;
    }

   
  }
}

Drawpixmap(display, window,gc,width, height)
GC gc;
int width, height;
Display *display;
Window window;
{
  XCopyArea(display, stipple, window, gc,0,0,web_width,web_height, width/2-web_width/2,height/2-web_height/2 );
}

redraw(display, window,gc,height,width)
int height,width;
Display *display;
Window window;
GC gc;
{
  XDrawLine(display,window, gc, topx+width/10, height/10,width/2, height/2);
  XDrawPoint(display, window, gc, width/2, height/4);
  XDrawArc(display, window,gc, width/4, height/5, 2*width/3,height/3,0, 64*180);
}

newline(display,window,gc, height,width)
int height,width;
Display *display;
Window window;
GC gc;
{
  XDrawLine(display,window, gc, topx+width/10, height/10,width/2, height/2);
  
  if(topx > width/10*8 || topx < 0) incr*=-1;
  topx+=incr;
  XDrawLine(display,window, gc, topx+width/10, height/10,width/2, height/2);

}
write_something(display,window,gc, height, width, font)
Display *display;
Window window;
XFontStruct *font;
GC gc;
int height, width;
{
  int x=10, y=5;
  char str1[]="This is the first line";
  char str2[]="this is the second line";
  char str3[]="this is not a string.. it's your imagination";
  int len1, len2,len3,len4;
  int width1,width2,width3;
  
  /* lenght in characters */
  len1=strlen(str1);
  len2=strlen(str2);
  len3=strlen(str3);

  /* get font text width */
  width1=XTextWidth(font, str1,len1);
  width2=XTextWidth(font, str2,len2);
  width3=XTextWidth(font, str3,len3);
  XFlush(display);
  XDrawString(display, window, gc, width/5, height/5, str1, len1);
  XDrawString(display, window, gc, width/5, height/5+10, str2, len2);
  XDrawString(display, window, gc, width/5, height/5+20, str3, len3);


}
