import java.awt.*;
import java.net.*;
import java.applet.*;
import java.io.*;

/**
 * The WobbleImage applet takes an image and independently oscillates it in the
 * vertical and horizontal directions.  Hence, the image wobbles.
 * 
 */
public class WobbleImage extends NoFlickerApplet implements Runnable {
  Image myimg;
  String myimgparam;
  URL myimgurl;
  int x,y,vx,vy,xcenter,ycenter,xvar,yvar;
  
/**
 * Reads applet parameters img which is the URL for the image,
 * xvar which says how much to oscillate in the horizontal direction,
 * and yvar which says how much to oscillate in the vertical direction.
 * 
 * The applet must have a height of the image plust twice yvar and a
 * width of the image plus twice xvar
 * 
 * 
 */  
  public void init() {
    myimgparam = getParameter("img");
    myimgurl = new URL(myimgparam);
    myimg = getImage(myimgurl);
    xvar = Integer.parseInt(getParameter("xvar"));
    yvar = Integer.parseInt(getParameter("yvar"));
    xcenter = xvar;
    ycenter = yvar;
    x = 2*xvar;
    y = 2*yvar;
    resize(100,100);
  }

/**
 * Start the wobbling
 */
  public void start() 
    {
      (new Thread(this)).start();
    }


/**
 * Perform the actual calculations for the oscillations
 */
  public void run() 
    {
      while(true)
	{
	  repaint();
	  Thread.currentThread().sleep(100);
	  x+=vx;
	  y+=vy;
	  if(x > xcenter)
	    {
	      vx--;
	    }
	  else if (x < xcenter)
	    {
	      vx++;
	    }
	  if(y > ycenter)
	    {
	      vy--;
	    }
	  else if (y < ycenter)
	    {
	      vy++;
	    }
	}
    }

/**
 * Draw the image
 */
  public void paint(Graphics g) {
    // This call draws the image at its normal size at the
      // upper left corner of the applet.
	if(myimg != null)
	  {
	    resize(myimg.getWidth(this)+2*xvar, myimg.getHeight(this)+2*yvar);
	    g.drawImage(myimg, x, y, this);
	  }
  }
}
