import com.sun.java.swing.JFrame;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.BoxLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Enumeration;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.io.File;

public class TaskLog implements java.awt.event.ActionListener
{
    JButton hsbutton, newbutton;
    JFrame f, bf, ef;
    JTextField tasktext;
    Hashtable tasks = new Hashtable();

    TaskLog(String args[]) {
	f = new JFrame();
	bf = new JFrame();
	ef = new JFrame();
	BoxLayout bl = new BoxLayout(f.getContentPane(), BoxLayout.Y_AXIS);
	f.getContentPane().setLayout(bl);

	// Add a button
	JButton hidelist = new JButton("Hide");
	hidelist.setActionCommand("hidetasks");
	hidelist.addActionListener(this);
	f.getContentPane().add(hidelist);
	
	// Load the database from disk
	if((new File("taskdb.obj")).exists()){
	    try {
		FileInputStream fis = new FileInputStream("taskdb.obj");
		ObjectInputStream ois = new ObjectInputStream(fis);
		tasks = (Hashtable) ois.readObject();
		fis.close();

		for(Enumeration en = tasks.keys();
		    en.hasMoreElements();){
		    Task t = (Task) en.nextElement();
		    t.wakeUp();
		    f.getContentPane().add(t.panel, this);
		}
	    }
	    catch (Exception e) {
		System.out.println("Problem reading database: "+e);
	    }
	}
	else {
	    // Otherwise start with some standard tasks
	    addTask("Read Email");
	    addTask("Read News");
	    addTask("Read Web");
	}
	f.doLayout();
	f.setSize(f.getPreferredSize().width+50, f.getPreferredSize().height+30);

	// Create some more buttons
	hsbutton = new JButton("Show");
	newbutton = new JButton("New");

	hsbutton.setActionCommand("showtasks");
	hsbutton.setEnabled(true);
	newbutton.setActionCommand("newtask");
	newbutton.setEnabled(true);
	hsbutton.addActionListener(this);
	newbutton.addActionListener(this);

	// Layout the buttons
	bf.getContentPane().setLayout(new FlowLayout());
	bf.getContentPane().add(hsbutton);
	bf.getContentPane().add(newbutton);

	// Build the form for entering a new task
	JLabel newtaskl = new JLabel("New Task: ");
	tasktext = new JTextField(50);
	JButton newtaskadd = new JButton("Add");
	ef.getContentPane().setLayout(new FlowLayout());
	ef.getContentPane().add(newtaskl);
	ef.getContentPane().add(tasktext);
	ef.getContentPane().add(newtaskadd);

	// Set what the buttons do
	tasktext.setActionCommand("addtask");
	newtaskadd.setActionCommand("addtask");
	newtaskadd.addActionListener(this);
	tasktext.addActionListener(this);

	// Layout everything
	ef.doLayout();
	ef.setSize(ef.getPreferredSize().width+50, ef.getPreferredSize().height+30);

	bf.doLayout();
	bf.setSize(bf.getPreferredSize().width+50, bf.getPreferredSize().height+30);
	bf.show();

	int tick=0;
	while(true){
	    hsbutton.setEnabled(false);
	    newbutton.setEnabled(false);

	    // Check if any of the tasks have changed,
	    // and if so, print it out and save the database
	    for(Enumeration e = tasks.keys(); e.hasMoreElements();){
		Task t = (Task) e.nextElement();
		int lp = ((Integer) tasks.get(t)).intValue();
		int cp = t.percentDone();
		if(lp != cp){
		    tasks.put(t, new Integer(cp));
		    System.out.println(System.currentTimeMillis()+" "+cp+"% "+t.desc);
		    if(cp == 100){
			System.out.println("Completed "+System.currentTimeMillis()+" "+t.desc);
			f.getContentPane().remove(t.panel);
			tasks.remove(t);
			f.doLayout();
			f.setSize(f.getPreferredSize().width+50, f.getPreferredSize().height+30);
			f.repaint();
		    }
		}
	    }
	    hsbutton.setEnabled(true);
	    newbutton.setEnabled(true);
	    dumpToDisk();
	    try { Thread.sleep(10*1000); } catch (Exception ex) { }
	    tick++;
	    if( tick > 60){
		tick = 0;
		f.show();
		hsbutton.setActionCommand("hidetasks");
		hsbutton.setText("Hide");
	    }
	}

    }

    public void actionPerformed(ActionEvent e){
	if(e.getActionCommand().equals("showtasks")){
	    f.show();
	    hsbutton.setActionCommand("hidetasks");
	    hsbutton.setText("Hide");
	}
	else if(e.getActionCommand().equals("hidetasks")){
	    f.hide();
	    hsbutton.setActionCommand("showtasks");
	    hsbutton.setText("Show");
	}
	else if(e.getActionCommand().equals("newtask")){
	    ef.show();
	}
	else if(e.getActionCommand().equals("addtask")){
	    addTask(tasktext.getText());
	    f.doLayout();
	    f.setSize(f.getPreferredSize().width+50, f.getPreferredSize().height+30);
	    f.repaint();
	    ef.hide();
	    tasktext.setText("");
	}
	else{
	    System.out.println("Action event: "+e.getActionCommand());
	}
    }

    public void addTask(String s) {
	Task t;
	t = new Task(s);
	f.getContentPane().add(t.panel, this);
	tasks.put(t, new Integer(0));
    }

    public void dumpToDisk() {
	try {
	    FileOutputStream fos = new FileOutputStream("taskdb.obj");
	    ObjectOutputStream oos = new ObjectOutputStream(fos);
	    oos.writeObject(tasks);
	    oos.flush();
	    fos.close();
	    System.out.println("Saved DB");
	} catch (IOException e) {
	    System.out.println("There was an error saving the database: "+e);
	}
    }

    
    public static void main(String args[]){
	new TaskLog(args);
    }
}


