/* Sample solution for Deep Magic with Lex & Yacc, IAP 1999, Problem 1.1. */

%{
#include <stdio.h>
int chars, words, lines;
char *progname;
%}


%%

[^ \t\n\r\v\f]+			words++, chars += yyleng;

\n				lines++, chars++;

.				chars++;

%%

usage ()
{
  fprintf (stderr, "Usage: %s [-lwc] [file]\n", progname);
  exit (1);
}

main (int argc, char **argv)
{
  int printlines, printwords, printchars, gotswitch;
  int i;
  char *infilename, *c;

  chars = words = lines = 0;
  printchars = printwords = printlines = gotswitch = 0;
  infilename = 0;
  
  progname = argv[0];

  for (i = 1; i < argc; i++)
    {
      if (argv[i][0] == '-')
	{
	  if (argv[i][1] == '\0')
	    usage ();
	  
	  gotswitch = 1;

	  for (c = &argv[i][1]; *c; c++)
	    switch (*c)
	      {
	      case 'c':
		printchars = 1;
		break;
		
	      case 'l':
		printlines = 1;
		break;
	      
	      case 'w':
		printwords = 1;
		break;

	      default:
		usage ();
	      }
	}
      else
	{
	  if (infilename)
	    usage ();	/* Don't permit multiple file names */

	  infilename = argv[i];
	}
    }

  if (!gotswitch)
    printchars = printlines = printwords = 1;

  if (infilename)
    {
      yyin = fopen (infilename, "r");
      if (!yyin)
	{
	  perror (infilename);
	  exit (1);
	}
    }
  
  yylex ();

  if (printlines)
    printf ("%7d ", lines);
  if (printwords)
    printf ("%7d ", words);
  if (printchars)
    printf ("%7d ", chars);
  if (infilename)
    printf ("%s", infilename);
  putchar ('\n');
  
  exit (0);
}
