/* Sample solution for Deep Magic with Lex & Yacc, IAP 1999, Problem 1.2. */

%{
#include <stdio.h>
int current_line;
char *input_file_name;
%}

%%

[ \t\f\v\r]	/* do nothing */

\n		current_line++;

[0-9]*		printf ("Literal\t%d\n", atoi (yytext));

[a-zA-Z_][a-zA-Z_0-9]*	printf ("Identifier\t%s\n", yytext);

\*\*		printf ("Operator\texp\n");

[-*/+^|&~=]	printf ("Operator\t%c\n", *yytext);

[]()[]		printf ("Grouper\t%c\n", *yytext);

.		{ fprintf (stderr,
			   "%s:%d: Illegal character %#o\n",
			   input_file_name, current_line, *yytext); }

%%

main (int argc, char **argv)
{
  if (argc > 2)
    {
      fprintf (stderr, "Usage: %s [filename]\n", argv[0]);
      exit (1);
    }
  
  if (argc == 2)
    {
      input_file_name = argv[1];
      yyin = fopen (input_file_name, "r");
      if (!yyin)
	{
	  perror (input_file_name);
	  exit (1);
	}
    }
  else
    input_file_name = "(standard input)";
  current_line = 1;

  yylex ();
  exit (0);
}
