/* Sample solution for Deep Magic with Lex & Yacc, IAP 1999, Problem 3.2. */
%{
#include <math.h>
%} 
 

%union 
{
  int intval;
  char *idval;
}

%token <intval> INT ID
%token EXP
%type <intval> expression 

%start wholefile

%%

wholefile:	interaction			{ printf ("vale crudele munde\n"); }
		;

interaction:	/* nothing */			{ printf ("salve munde\n"); }
		| interaction topexpression	
		;

topexpression:	expression '.'			{ printf ("%d\n", $1); }

expression:	expression expression '+'	{ $$ = $1 + $2; }
		| expression expression '-'	{ $$ = $1 - $2; }
		| expression expression '*'	{ $$ = $1 * $2; }
		| expression expression '/'	{ $$ = $1 / $2; }
		| expression expression	EXP
			{ $$ = (int) pow ((double) $1, (double) $2); }
		| INT				{ $$ = $1; }
		;

%%

main ()
{
  yyparse ();
}

