/* Scanner for future calculator problems. */

%{
#include <stdio.h>
#include <assert.h>

#ifdef PARSER_HEADER
#include PARSER_HEADER
#else
/* Token types.  Single character tokens have the type of their value. */
#define INT		256
#define ID		257
#define EXP		258
#define EOF		259

/* Token values */
union token_value
{
  int intval;
  char *idval;
} yylval;
#endif


int current_line;
char *input_file_name;

char *copy_string (char *);

int received_error;

%}

%%

[ \t\f\v\r]	/* do nothing */

\n		current_line++;

[0-9]*		{ yylval.intval = atoi (yytext); return INT; }

[a-zA-Z_][a-zA-Z_0-9]*	{ yylval.idval = copy_string (yytext); return ID; }

\*\*		return EXP;

[]()[*./+^|&~=-]  return *yytext;

.		{ received_error = 1;
		  fprintf (stderr,
			   "%s:%d: Illegal character %#o\n",
			   input_file_name, current_line, *yytext); }

%%

char *
copy_string (char *s)
{
  char *s2 = malloc (strlen (s) + 1);
  assert (s2);
  strcpy (s2, s);
  return s2;
}

#ifdef STANDALONE
main (int argc, char **argv)
{
  int token;

  if (argc > 2)
    {
      fprintf (stderr, "Usage: %s [filename]\n", argv[0]);
      exit (1);
    }
  
  if (argc == 2)
    {
      input_file_name = argv[1];
      yyin = fopen (input_file_name, "r");
      if (!yyin)
	{
	  perror (input_file_name);
	  exit (1);
	}
    }
  else
    input_file_name = "(standard input)";
  current_line = 1;

  while ((token = yylex ()) != EOF)
    switch (token)
      {
      case INT:
	printf ("Constant\t%d\n", yylval.intval);
	break;
	
      case ID:
	printf ("Identifier\t%s\n", yylval.idval);
	break;
	
      case EXP:
	printf ("Operator\texp\n");
	break;
	  
      default:
	printf ("Operator\t%c\n", token);
	break;
      }

  exit (received_error);
}
#endif
