#include <stdio.h>
#include <X11/Xlib.h>   
#include <X11/Xutil.h>	
#include <X11/Xos.h>

main(argc, argv)
int argc;
char *argv[];
{
  Window window,rootwindow;
  Display *display;
  GC gc;
  XGCValues *gcvalues;
  XEvent xevent;
  XConfigureEvent *configureevent;
  XButtonPressedEvent *buttonpressed;
  int screen,width=100 , height=100;
  XSizeHints size_hints;
  int lookupstring;
  char buffer[2];
  int counter;
  unsigned int button;

  if((display = XOpenDisplay(NULL))==NULL) {  /*try to open up a display */
    fprintf(stderr, "cannot connect to X server %s \n", XDisplayName(NULL));
    exit(-1);
  }
  screen=DefaultScreen(display); /* get :0.0  <= last 0 */
  rootwindow = RootWindow(display,screen); /*get parent window id */
  gc = XCreateGC(display, rootwindow, 0, gcvalues);


  size_hints.width = 50;
  size_hints.height = 75;
  size_hints.min_width = 10;
  size_hints.min_height = 5;

  window=XCreateSimpleWindow(display,rootwindow,100,100,120,120,3,
	  BlackPixel(display,screen),WhitePixel(display,screen));

  XStoreName(display,window, "My first window");
  XSetIconName(display, window, "Window name");

  XSelectInput(display, window, ExposureMask | ButtonPressMask
	       | StructureNotifyMask |KeyPressMask);

  
  
  XMapWindow(display,window);

  XFlush(display);
  while(1){ 
    XNextEvent(display, &xevent );
    switch(xevent.type) {
    case ConfigureNotify:
      width=xevent.xconfigure.width;
      height=xevent.xconfigure.height;
      break;
    case KeyPress:
      lookupstring = XLookupString(&xevent, buffer, 2, NULL, NULL);
      for(counter=0;counter<lookupstring; counter++) {
	printf("%c\n",buffer[counter]);
	printf("ascii code = %d \n",buffer[counter]);
      }
      printf("\n");
      break;
    case ButtonPress:
      buttonpressed=(XButtonPressedEvent *) &xevent;
      printf("Button pressed is: %d \n", buttonpressed->button);
      break;
    case Expose:
      redraw(display, window, gc,height, width);
      break;
    }

   
  }
}

redraw(display, window,gc,height,width)
int height,width;
Display *display;
Window window;
GC gc;
{
  XClearWindow(display,window);
  XDrawLine(display,window, gc, width/10, height/5,width/2, height/2);
  XDrawPoint(display, window, gc, width/3, height/4);
  XDrawArc(display, window,gc, width/4, height/5, 2*width/3,height/3,0, 64*180);
  
}
