import java.awt.*;
import java.awt.image.ColorModel;
import java.net.URL;
import java.net.MalformedURLException;
import java.applet.Applet;

/**
 *
 *  Extension to base applet class to avoid display flicker.
 *  Basically, NoFlickerApplet implements simple double buffering.  Normally,
 *  the applet (and components in general) implement an update method which clears
 *  the drawing area and calls the paint method.  This can yield a lot of flicker.
 *  NoFlickerApplet overrides that default update method and creates an offscreen
 *  buffer where drawing is actually done.  This offscreen buffer is then copied
 *  wholesale onto the screen, without clearing it first (the whole thing is drawn
 *  over) eliminating the flicker.
 *
 * Copyright (C) 1996 by Matthew Gray
 *
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of Matthew Gray or net.Genesis not be used in advertising or 
 * publicity pertaining to distribution of the software without specific, 
 * written prior permission.  I make no representations about the 
 * suitability of this software for any purpose.  It is provided "as is" 
 * without express or implied warranty.
 *
 * @version		1.0, 27 Oct 1995
 * @author		Matthew Gray
 *
 */

public class NoFlickerApplet extends Applet {
  private Image offScreenImage;
  private Graphics offScreenGraphics;
  private Dimension offScreenSize;
  
  /**
   * NoFlickerApplet uses a final version of update because if you override its
   * update method, it won't do what it does. :-)
   */

  public final synchronized void update (Graphics theG)
    {
      Dimension d = size();
      if((offScreenImage == null) || (d.width != offScreenSize.width) ||
	 (d.height != offScreenSize.height)) 
	{
	  offScreenImage = createImage(d.width, d.height);
	  offScreenSize = d;
	  offScreenGraphics = offScreenImage.getGraphics();
	  offScreenGraphics.setFont(getFont());
	}
      offScreenGraphics.fillRect(0,0,d.width, d.height);
      paint(offScreenGraphics);
      theG.drawImage(offScreenImage, 0, 0, null);
    }
}
