import com.sun.java.swing.JSlider;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.SwingConstants;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.io.Serializable;

public class Task 
    implements Serializable {
    String desc;
    int complete;

    JSlider slider;
    JLabel label;
    public JPanel panel;
    
    // Create a new Task
    Task(String s){
	setup(s);
    }

    // All the work necassary to create
    // or reinitialize a Task
    public void setup(String s) {
	panel = new JPanel();
	panel.setLayout(new GridLayout(1,2));
	slider = new JSlider(SwingConstants.HORIZONTAL, 0, 100, 0);
	slider.createStandardLabels(10);
	desc = s;
	label = new JLabel(s);
	slider.setPaintTicks(true);
	slider.setPaintLabels(true);
	slider.setMajorTickSpacing(10);
	slider.setSize(225, slider.getHeight());
	slider.setToolTipText("Percent Done");
	label.setToolTipText("Task");
	panel.add(slider);
	panel.add(label);
	panel.doLayout();
    }

    // Reconstruct the task after being loaded
    // from disk
    public void wakeUp() {
	setup(desc);
	slider.setValue(complete);
    }

    // Get the percent done for this task
    public int percentDone() {
	complete = slider.getValue();
	return complete;
    }

}
