/* Sample solution for Deep Magic with Lex & Yacc, IAP 1999, Problem 2.1. */

%{
#include <stdio.h>
#include <alloca.h>

int chars, words, lines;
char *progname;
%}

%%

[^ \t\n\r\v\f]+			words++, chars += yyleng;

\n				lines++, chars++;

[ \t\r\v\f]+			chars += yyleng;

%%

char *current_file_name;
int total_chars, total_words, total_lines;
int printlines, printwords, printchars;

struct infile
{
  char *name;
  struct infile *next;
} *filelist;

usage ()
{
  fprintf (stderr, "Usage: %s [-lwc] [file]\n", progname);
  exit (1);
}

FILE *
open_next_input_file ()
{
  FILE *f;

  while (filelist)
    if (f = fopen (filelist->name, "r"))
      {
	current_file_name = filelist->name;
	filelist = filelist->next;
	return f;
      }
    else
      {
	perror (filelist->name);
	filelist = filelist->next;
      }

  return 0;
}
  
int
yywrap ()
{
  FILE *f;
  
  if (printlines)
    printf ("%7d ", lines);
  if (printwords)
    printf ("%7d ", words);
  if (printchars)
    printf ("%7d ", chars);
  if (current_file_name)
    printf ("%s", current_file_name);
  putchar ('\n');

  total_lines += lines;
  total_words += words;
  total_chars += chars;
  lines = words = chars = 0;

  f = open_next_input_file ();
  if (f)
    yyrestart (f);
  return !f;
}

main (int argc, char **argv)
{
  int gotswitch;
  int i;
  char *c;
  struct infile **curtailp;
  int print_total;

  chars = words = lines = 0;
  total_chars = total_words = total_lines = 0;
  printchars = printwords = printlines = gotswitch = 0;
  print_total = 0;

  curtailp = &filelist;
  
  progname = argv[0];

  for (i = 1; i < argc; i++)
    {
      if (argv[i][0] == '-')
	{
	  if (argv[i][1] == '\0')
	    usage ();
	  
	  gotswitch = 1;

	  for (c = &argv[i][1]; *c; c++)
	    switch (*c)
	      {
	      case 'c':
		printchars = 1;
		break;
	      case 'l':
		printlines = 1;
		break;
	      case 'w':
		printwords = 1;
		break;
	      default:
		usage ();
	      }
	}
      else
	{
	  struct infile *f = alloca (sizeof (struct infile));

	  /* If filelist has gotten set, this is at least th
	     second file name. */
	  if (filelist)
	    print_total = 1;

	  f->name = argv[i];
	  f->next = 0;
	  *curtailp = f;
	  curtailp = &f->next;
	}
    }

  if (!gotswitch)
    printchars = printlines = printwords = 1;

  if (filelist)
    {
      yyin = open_next_input_file ();
      if (yyin)
	yylex ();
    }
  else
    yylex ();

  if (print_total)
    {
      if (printlines)
	printf ("%7d ", total_lines);
      if (printwords)
	printf ("%7d ", total_words);
      if (printchars)
	printf ("%7d ", total_chars);
      printf ("total\n");
    }
  
  exit (0);
}
