/* Sample solution for Deep Magic with Lex & Yacc, IAP 1999, Problem 3.1. */
%{
#include <math.h>
%} 
 

%union 
{
  int intval;
  char *idval;
}

%token <intval> INT ID
%token EXP
%type <intval> expression 

%start interaction

%%

interaction:	/* nothing */			{ printf ("salve munde\n"); }
		| interaction topexpression
		;

topexpression:	expression			{ printf ("%d\n", $1); }

expression:	'+' expression expression	{ $$ = $2 + $3; }
		| '-' expression expression	{ $$ = $2 - $3; }
		| '*' expression expression	{ $$ = $2 * $3; }
		| '/' expression expression	{ $$ = $2 / $3; }
		| EXP expression expression	
			{ $$ = (int) pow ((double) $2, (double) $3); }
		| INT				{ $$ = $1; }
		;

%%

main ()
{
  yyparse ();
}

