/* server.cc: Handle the server socket. */

#include "threads.h"
#include "error.h"

#include "Server.h"
#include "Connection.h"

extern "C" {
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
}

static struct sockaddr_in addr;		/* An internet address. */
static int addr_size = sizeof(addr);	/* Size of addr. */

Server::Server(int port)
{
    int one = 1, result;
    
    /* Create the server socket. */
    server_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (server_socket < 0)
	die("Couldn't create server socket: %s\n", strerror(-server_socket));

    /* Set SO_REUSEADDR option to avoid restart problems. */
    one = 1;
    setsockopt(server_socket, SOL_SOCKET, SO_REUSEADDR, (char *) &one,
	       sizeof(int));

    /* Bind the socket to <port>. */
    addr.sin_family = AF_INET;
    addr.sin_port = htons((unsigned short) port);
    result = bind(server_socket, (struct sockaddr *) &addr, sizeof(addr));
    if (result < 0)
	die("Couldn't bind to port %d: %s\n", port, strerror(-result));

    /* Start listening on <port>.  This shouldn't return an error under any
     * circumstances. */
    listen(server_socket, 8);
}

Connection *Server::accept()
{
    int client_socket;

    client_socket = ::accept(server_socket, &addr, &addr_size);
    if (client_socket < 0)
	die("Failed to accept connection: %s\n", strerror(-client_socket));

    printf("Accepted file descriptor %d.\n", client_socket);
    return new Connection(client_socket);
}

