/* hunting for the dropping-a-file-descriptor bug... SNL 6 April 1995 */

#include <stdio.h>
#include <math.h>
#include <tmp/libpq.h>
#include <tmp/libpq-fs.h>
#include <catalog/pg_lobj.h>

struct {
  char *name;
  char *host;
  char *port;
} databases[] = {
  { "snl", "paneer.ndim.edrc.cmu.edu", "3740" },
  { "ndim_published", "massif.edrc.cmu.edu", "4300" },
  { "ndim_public", "massif.edrc.cmu.edu", "4300" }
};
int n_databases = sizeof(databases) / sizeof(databases[0]);
int test_count = 1000;
extern char *PQhost, *PQport;

main(int argc, char **argv)
{
  int i, db;

  pthread_init();
  setbuf(stdout, NULL);
  setbuf(stderr, NULL);
  printf("switching between %d databases %d times...\n", n_databases,
	 test_count);
  for (i = db = 0; i < test_count; i++, db = (++db % n_databases)) {
    int g, n_groups, n_tuples;
    char *result, *PQexec();
    PortalBuffer *pbuf;

    printf("%d: db %d...", i, db);
    PQhost = databases[db].host;
    PQport = databases[db].port;
    PQsetdb(databases[db].name);
    result = PQexec(" ");
    switch (*result) {
    case 'I':
      break;
    default:
      printf("error (%s)\n", result);
      exit(1);
      break;
    }
    printf("connected...");
    (void) PQexec("begin");
    (void) PQexec("retrieve portal tportal (models.all)");
    (void) PQexec("fetch all in tportal");
    pbuf = PQparray("tportal");
    n_groups = PQngroups(pbuf);
    n_tuples = 0;
    for (g = 0; g < n_groups; g++)
      n_tuples += PQntuplesGroup(pbuf, g);
    printf("got %d tuples in %d groups.\n", n_tuples, n_groups);
    PQexec("close tportal");
    PQexec("end");
    PQfinish();
  }
}
