/* Driver for routine four1 */

#include <stdio.h>
#include "complex.h"
#define NRANSI
#define SQR(x) (x)*(x)

void four1(real[], unsigned long, int);

void prntft(real data[],unsigned long nn)
{
	unsigned long n;

	printf("%4s %14s %12s %12s %12s\n",
		"n","Dreal(n)","Dimag.(n)","Sreal(n)","Simag.(n)");
	printf("   0 %14.6g %12.6g %12.6g %12.6g\n",
	       (double)(data[0]-data[0]),(double)(data[1]-data[1]),
	       (double)(data[0]+data[0]),(double)(data[1]+data[1]));
	for (n=3;n<=nn+1;n+=2) {
	  printf("%4lu %14.6g %12.6g %12.6g %12.6g\n",
		 ((n-1)/2),
		 (double)(data[n-1]-data[2*nn+1-n]),
		 (double)(data[n]-data[2*nn+2-n]),
		 (double)(data[n-1]+data[2*nn+1-n]),
		 (double)(data[n]+data[2*nn+2-n]));
	}
	printf(" press return to continue ...\n");
	(void) getchar();
	return;
}

#define NN 32
#define NN2 (2*NN)

int main(void)
{
	long i;
	int isign;
	real data[NN2],dcmp[NN2];

	printf("h(t)=real-valued even-function\n"
	       "h(n)=h(N-n) and real?\n");
	for (i=1;i<NN2;i+=2) {
		data[i-1]=1.0/(SQR((real) (i-NN-1)/NN)+1.0);
		data[i]=0.0;
	}
	isign=1;
	fft((complex*)data,NN,isign);
	prntft(data,NN);
	printf("h(t)=imaginary-valued even-function\n"
	       "h(n)=h(N-n) and imaginary?\n");
	for (i=1;i<NN2;i+=2) {
		data[i]=1.0/(SQR((real) (i-NN-1)/NN)+1.0);
		data[i-1]=0.0;
	}
	isign=1;
	fft((complex*)data,NN,isign);
	prntft(data,NN);
	printf("h(t)=real-valued odd-function\n"
	       "h(n) = -h(N-n) and imaginary?\n");
	for (i=1;i<NN2;i+=2) {
		data[i-1]=((real) (i-NN-1)/NN)/(SQR((real) (i-NN-1)/NN)+1.0);
		data[i]=0.0;
	}
	data[0]=0.0;
	isign=1;
	fft((complex*)data,NN,isign);
	prntft(data,NN);
	printf("h(t)=imaginary-valued odd-function\n"
	       "h(n) = -h(N-n) and real?\n");
	for (i=1;i<NN2;i+=2) {
		data[i]=((real) (i-NN-1)/NN)/(SQR((real) (i-NN-1)/NN)+1.0);
		data[i-1]=0.0;
	}
	data[1]=0.0;
	isign=1;
	fft((complex*)data,NN,isign);
	prntft(data,NN);

	/* transform, inverse-transform test */
	for (i=1;i<NN2;i+=2) {
		data[i-1]=1.0/(SQR(0.5*(i-NN-1.0)/NN)+1.0);
		dcmp[i-1]=data[i-1];
		data[i]=(0.25*(i-NN-1.0)/NN)*exp(-SQR(0.5*(i-NN-1)/NN));
		dcmp[i]=data[i];
	}
	isign=1;
	fft((complex*)data,NN,isign);
	isign = -1;
	fft((complex*)data,NN,isign);
	printf("data - ifft(fft(data)) == 0?\n"
	       " %3s %15s %12s\n",
	       "k","Dreal h(k)","Dimag h(k)");
	for (i=1;i<NN;i+=2)
		printf("%4lu %14.6g %12.6g\n",
		       (i+1)/2,
		       (double)(dcmp[i-1]-(data[i-1]/NN)),
		       (double)(dcmp[i]-(data[i]/NN)));
	printf(" press return to continue ...\n");
	(void) getchar();

	/* test of consistency I */
	for (i=1;i<NN2;i+=2) {
		data[i-1]=1.0/(SQR(0.5*(i-NN-1.0)/NN)+1.0);
		dcmp[i-1]=data[i-1];
		data[i]=(0.25*(i-NN-1.0)/NN)*exp(-SQR(0.5*(i-NN-1)/NN));
		dcmp[i]=data[i];
	}
	isign=1;
	fft((complex*)data,NN,isign);
	four1(dcmp-1,NN,isign);	
	printf("NR_implementation_fft(data) - fft(data) == 0?\n"
	       " %3s %15s %12s\n",
	       "k","Dreal h(k)","Dimag h(k)");
	for (i=1;i<NN;i+=2)
		printf("%4lu %14.6g %12.6g\n",
		       (i+1)/2,
		       (double)(dcmp[i-1]-data[i-1]),
		       (double)(dcmp[i]-data[i]));
	printf(" press return to continue ...\n");
	(void) getchar();
	/* test of consistency II */
	for (i=1;i<NN2;i+=2) {
		data[i-1]=1.0/(SQR(0.5*(i-NN-1.0)/NN)+1.0);
		dcmp[i-1]=data[i-1];
		data[i]=(0.25*(i-NN-1.0)/NN)*exp(-SQR(0.5*(i-NN-1)/NN));
		dcmp[i]=data[i];
	}
	isign=-1;
	fft((complex*)data,NN,isign);
	four1(dcmp-1,NN,isign);
	printf("NR_implementation_ifft(data) - ifft(data) == 0?\n"
	       " %3s %15s %12s\n",
	       "k","Dreal h(k)","Dimag h(k)");
	for (i=1;i<NN;i+=2)
		printf("%4lu %14.6g %12.6g\n",
		       (i+1)/2,
		       (double)(dcmp[i-1]-data[i-1]),
		       (double)(dcmp[i]-data[i]));
	return 0;
}
#undef NRANSI
