/* $Id: oppack.h,v 1.3 1995/07/13 17:23:18 bert Exp $
 * header for functions for generating of packets and operators
 */

#ifndef _OPPACK_H
#define _OPPACK_H

#include "complex.h"

/* constants */

extern real hbar;
extern real mass;

/* prototypes */

/* generate matrix of coefficients for potential part of propagator */
void generate_Vprop_nelson (complex *V, long n,
			    double dt, double delta, double vcoef, double mu);
void generate_Vprop_harmonic (complex *V, long n,
			    double dt, double delta, double vcoef, double mu);
void generate_Vprop_constant (complex *V, long n,
			    double dt, double delta, double vcoef, double mu);

typedef void (*Vprop_gen_f)(complex*, long, double, double, double, double);

/* generate matrix of coefficients for kinetic part of propagator */
void generate_Kprop (complex *K, long n, double dt, double delta);

/* generate a Gaussian wave packet in coordinate form */
void generate_packet (complex *pack, long n, double rx, double ry,
	         double kx, double ky, double delta, double eps, double ncoef);

/* copy an NxN array (A -> B) */
void copy_data (complex *A, complex *B, long n);

#endif
