/*
 * Fast Fourier Transform algorithm.
 * Adapted from "Numerical Recipes".
 */

#include <math.h>
#include "complex.h"

#define SWAP(a,b) temp=(a);(a)=(b);(b)=temp

void four1(complex data[], unsigned long nn, int isign)
{
	unsigned long n,mmax,m,j,istep,i;
	double theta;

	complex w,wp,temp;

	n=nn << 1;
	j=0;
	for (i=0; i<nn; i++) {
		if (j > i) {
			SWAP(data[j],data[i]);
		}
		m=n >> 2;
		while (m >= 1 && j >= m) {
			j -= m;
			m >>= 1;
		}
		j += m;
	}
	mmax=1;
	while (n > (2*mmax)) {
		istep=mmax << 1;
		theta=isign*(M_PI/mmax);
		wp=cexp(theta*1i)-1.0;
		w = 1.0;
		for (m=0; m<mmax; m++) {
			for (i=m; i<nn; i+=istep) {
				j=i+mmax;
				temp=w * data[j];
				data[j]=data[i] - temp;
				data[i] += temp;
			}
			w = (w*wp) + w;
		}
		mmax=istep;
	}
}
#undef SWAP
