/* $Id: twodim-fft-test.c,v 1.1 1994/11/14 01:50:16 bert Exp $
 *
 * 2-dimensional exact solution of Schr{\""o}dinger's eqn
 * using short-time propagators
 */

#include "complex.h"
#include "fft.h"
#include <stdio.h>
#include <stdlib.h>

#define SIZE    128
#define NDAT2   SIZE*SIZE

float ran1(long *idum);

int main(int argc, char **argv)
{
  long idum=(-23);
  unsigned long i,j,k,l,ndum=2,nn[2];
  real data1[NDAT2],data2[NDAT2],maxerr;

  long niter= (argc>1) ? (atol(argv[1])) : 100;

  for (i=1;i<=2;i++) nn[i-1]=(ndum <<= 1);
  for (j=1;j<=nn[1];j++)
    for (k=1;k<=nn[0];k++) {
      l=k+(j-1)*nn[0];
      l=(l<<1)-1;
      /* real part of component */
      data2[l-1]=data1[l-1]=2*ran1(&idum)-1;
      /* imaginary part of component */
      l++;
      data2[l-1]=data1[l-1]=2*ran1(&idum)-1;
    }

  ndum=nn[0]*nn[1];
  for (i=1; i<=niter; i++) {
    fft2(data2,nn,1);
    fft2(data2,nn,-1);
    for (j=1;j<=nn[1];j++)
      for (k=1;k<=nn[0];k++) {
	l=k+(j-1)*nn[0];
	l=(l<<1)-1;
	data2[l-1] /= ndum;
	data2[l] /= ndum;
      }
    fprintf(stdout,"[%ld] ",i);
    fflush(stdout);
  }
  fprintf(stdout,"\n");

  printf("\n2-dimensional transform-and-back, %ld time(s)\n\n", niter);
  printf("%10s %13s %12s %13s %11s %13s\n\n",
	 "real","imag.","real","imag.","real","imag.");
  maxerr=0;
  for (j=1;j<=nn[1];j++)
    for (k=1;k<=nn[0];k++) {
      real err1=data2[l-1]-data1[l-1];
      real err2=data2[l]-data1[l];
      l=k+(j-1)*nn[0];
      l=(l<<1)-1;
      printf("%9.2Lf %9.2Lf %9.2Lf %9.2Lf %17.10Lg %17.10Lg\n",
	     data2[l-1],data2[l],data1[l-1],data1[l],err1,err2);
      if (maxerr<err1) maxerr=err1;
      if (maxerr<err2) maxerr=err2;
    }
  printf("\nThe product of transform lengths is: %4lu\n",ndum);
  printf("Maximum error: %17.10Lg\n",maxerr);
  return 0;
}
