#ifndef _URL_OPS_H
#define _URL_OPS_H

#include "6170.h"

// A pathname consists of a series of components separated by some
// number of slashes. Initial and final slashes are ignored, so
// "//a//", "a", and "/a" are all considered equivalent. A component
// must contain at least one non-slash character.  All URIs are
// considered not to have escaped characters excluding routines that
// escape or unescape URIs.

string extract_pathname(string URL);
    // Remove any query arguments from the URL, returning a pathname.
    // The returned pathname will start with a character other than '/':
    // the root path is represented as an empty string.
string extract_query(string url);
    // Return just the query/search arguments portion of the URL,
    // not including the question mark (?). Return the empty string if there
    // are no query arguments.
string first_component(string url_or_pathname);
    // Return the first segment of a pathname or a URL string. The empty 
    // string is returned if the URL or pathname is the root.  The query string is not considered part of the first component.
string rest_components(string url_or_pathname);
    // Requires: the pathname or url must contain more than one component.
    // Effects: returns all but the first segment of a pathname or a URL
    // string. The empty string is returned if the URL/pathname is the root.
string last_component(string url_or_pathname);
    // Return the last segment of a pathname or a URL string. The empty
    // string is returned if the URL or pathname is the root.
string extension(string pathname);
    // Return the extension on the last component of "pathname", e.g.
    // "extension(``foo.html'') == ``html''" If there is no extension,
    // return the empty string.

    bool unescape_uri(string in, string &out);
// Effects: rewrites characters of the form %xx wher xx is a hex digit
// with the appropriate unescaped character.  If in contains %
// followed by something other than two hex digits, returns false else
// returns true. */
//  Modifies: out

string escape_uri(string uri);
// Effects: returns a URI containing only  characters acceptible under RFC1738.


map <string, string> *parse_query(string query);
// Effects: Returns a map of the fields in query after unescaping both
// the field names and values.  If the query string is not of the form
// |field=value[&field=value[...]]|, return null.


string safeify_filename(string s);
// Effects: removes all non-ASCII characters from a filename.


#endif /* _URL_OPS_H */
