/* assert.h standard header
 * $Version: 1.3 $
 * Copyright (c) 1993 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef __ASSERTH__
#define __ASSERTH__

#include <yvals.h>

#undef assert /* remove existing definition */
#ifdef NDEBUG

#ifdef __cplusplus
extern "C" {
#endif

/*
 * passive form
 */

#define assert(ignore)

#else /* NDEBUG */

void _Pascal _Assert(char *);

/*
 * macro definition
 */

#define _STR(x) _VAL(x)
#define _VAL(x) #x
#define assert(test)    ((test) ? (void)0 \
	: _Assert(__FILE__":"_STR(__LINE__) " " #test))

#endif /* NDEBUG */

#ifdef __cplusplus
}
#endif

#endif		/* __ASSERTH__ */
