/* rmx_err.h iRMX header 
 * $Version: 1.3 $
 * Copyright (c) 1991, 93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _RMX_ERR
#define _RMX_ERR

/*
 * errno.h macro definitions
 */

#ifndef E_BUSY
#define E_BUSY                  0x3     /* region is in use */
#define E_EXIST                 0x6     /* token is not an iRMX object */
#define E_IO                    0x2b    /* io error */
#endif

/*
 * iRMX Nucleus environmental errors
 */

#define E_OK                    0x0
#define E_TIME                  0x1     /* TIME limit exceeded */
#define E_MEM                   0x2     /* memory allocation exceeded */
#define E_LIMIT                 0x4     /* some limit exceeded */
#define E_CONTEXT               0x5     /* request out of context */
#define E_STATE                 0x7     /* ready task resumed */
#define E_NOT_CONFIGURED        0x8
#define E_INTERRUPT_SATURATION  0x9     /* interrupt task accumulated
                                           the maximum allowable number of
                                           SIGNAL$INTERRUPT requests */
#define E_INTERRUPT_OVERFLOW    0xa     /* interrupt task accumulated more than
										   the maximum allowable number of
                                           SIGNAL$INTERRUPT requests */
#define E_TRANSMISSION          0xb     /* error in message transmission */
#define E_SLOT                  0xc     /* there are no available GDT slots */
#define E_DATA_CHAIN            0xd     /* buffer returned is a data chain */

/*
 * iRMX Nucleus Communication Service environmental errors
 */

#define E_CANCELLED         0xe1    /* RSVP transaction cancelled by remote
									   host */
#define E_HOST_ID           0xe2    /* invalid host id parameter */
#define E_NO_LOCAL_BUFFER   0xe3    /* insufficient buffer available on local
									   host to receive message */
#define E_NO_REMOTE_BUFFER  0xe4    /* insufficient buffer available on
									   remote host to receive message */
#define E_RESOURCE_LIMIT    0xe6    /* exceeded limit of number of
									   simultaneous messages */
#define E_TRANS_ID          0xe8    /* invalid transaction id parameter */
#define E_DISCONNECTED      0xe9    /* null socket parameter used with port
									   that is not connected */
#define E_TRANS_LIMIT       0xea    /* exceeded limit of number of
                                       simultaneous transactions */    

/*
 * iRMX BIOS environmental errors
 */

#define E_FEXIST            0x20    /* file already exists */
#define E_FNEXIST           0x21    /* non-existant File  */
#define E_DEVFD             0x22    /* device and file driver incompatible */
#define E_SUPPORT           0x23    /* function not supported */
#define E_EMPTY_ENTRY       0x24    /* directory entry is empty */
#define E_DIR_END           0x25    /* no more directory entries */
#define E_FACCESS           0x26    /* access to file denied */
#define E_FTYPE             0x27    /* invalid file type */
#define E_SHARE             0x28    /* file cannot be shared with others */
#define E_SPACE             0x29    /* insufficient space on volume */
#define E_IDDR              0x2a    /* bad device driver request */
#define E_FLUSHING          0x2c    /* other end of stream file is gone */
#define E_ILLVOL            0x2d    /* illegal volume type */
#define E_DEV_OFFLINE       0x2e    /* device is off line */
#define E_IFDR              0x2f    /* illegal file driver request */
#define E_FRAGMENTATION     0x30    /* file too fragmented to extend */
#define E_DIR_NOT_EMPTY     0x31    /* directory not empty */
#define E_NOT_FILE_CONN     0x32    /* not a file connection */
#define E_NOT_DEVICE_CONN   0x33    /* not a device connection */
#define E_CONN_NOT_OPEN     0x34    /* connection is not open for requested
									   operation */
#define E_CONN_OPEN         0x35    /* connection already open */
#define E_BUFFERED_CONN     0x36    /* connection opened by EIOS but now
									   accessed by BIOS */
#define E_OUTSTANDING_CONNS 0x37    /* specified soft detach has left device
									   connections intact */
#define E_ALREADY_ATTACHED  0x38    /* device already attached */
#define E_DEV_DETACHING     0x39    /* specified file on a device in the
									   process of being detached */
#define E_NOT_SAME_DEVICE   0x3a    /* existing and new pathnames not on
									   same device */
#define E_ILLOGICAL_RENAME  0x3b    /* new pathname includes existing
									   pathname */
#define E_STREAM_SPECIAL    0x3c    /* stream file request out of context */
#define E_INVALID_FNODE     0x3d    /* invalid file descriptor */
#define E_PATHNAME_SYNTAX   0x3e    /* pathname null or contains invalid
									   characters */
#define E_FNODE_LIMIT       0x3f    /* insufficient fnodes on volume */
                                         
/*
 * iRMX EIOS environmental errors
 */
    
#define E_LOG_NAME_SYNTAX   0x40    /* invalid logical name */
#define E_CANNOT_CLOSE      0x41    /* buffers cannot be flushed */
#define E_IOMEM             0x42    /* IO system has insufficent memory */
#define E_MEDIA             0x44    /* no disk in drive */
#define E_LOG_NAME_NEXIST   0x45    /* logical name does not exist  */
#define E_NOT_OWNER         0x46    /* user trying to detach a device is not
									   the device's owner */
#define E_IO_JOB            0x47    /* job is not a valid IO job */
#define E_UDF_FORMAT        0x48    /* udf is corrupted */
#define E_NAME_NEXIST       0x49    /* user name not present in udf */
#define E_UID_NEXIST        0x4a    /* user token doesn't match udf */
#define E_PASSWORD_MISMATCH 0x4b    /* incorrect password */
#define E_UDF_IO            0x4c    /* specified UDF file cannot be found */
#define E_IO_UNCLASS        0x50    /* an unclassified error has occured */
#define E_IO_SOFT           0x51    /* soft error has occured */
#define E_IO_HARD           0x52    /* hard error has occured */
#define E_IO_OPRINT         0x53    /* device is not ready */
#define E_IO_WRPROT         0x54    /* write protected */
#define E_IO_NO_DATA        0x55    /* no data on the next TAPE record */
#define E_IO_MODE           0x56    /* a tape drive attempted a read/write
									   operation before the previous one
                                       completed */
#define E_IO_NO_SPARES      0x57    /* an attempt was made to assign an
									   alternate track, but no more were
                                       available */
#define E_IO_ALT_ASSIGNED   0x58    /* an alternate was assigned during this
									   I/O operation */

/*
 * iRMX AL environmental errors
 */

#define E_BAD_HEADER        0x62    /* an invalid object file header */
#define E_EOF               0x65    /* unexpected End of File while reading
                                       a record */
#define E_NO_LOADER_MEM     0x67
#define E_NO_START          0x6c    /* the Application Loader could not find
                                       the start address */
#define E_JOB_SIZE          0x6d    /* The max. memory pool size of job being
                                       loaded is smaller than the amount
                                       required to load it */
#define E_OVERLAY           0x6e    /* the overlay name does not match */
#define E_LOADER_SUPPORT    0x6f    /* The file requires features not
									   supported by this configuration of the
                                       Application Loader */
                                         
/*
 * iRMX HI environmental errors
 */
    
#define E_LITERAL           0x80    /* literal with no closing quote detected
									   while parsing */
#define E_STRING_BUFFER     0x81    /* buffer too small for O.S. returned
									   string */
#define E_SEPARATOR         0x82    /* illegal command separator */
#define E_CONTINUED         0x83    /* user parse buffer is continued */
#define E_INVALID_NUMERIC   0x84    /* invalid form of number */
#define E_LIST              0x85    /* missing value-list value */
#define E_WILDCARD          0x86    /* invalid wildcard character usage */
#define E_PREPOSITION       0x87    /* invalid preposition usage */
#define E_PATH              0x88    /* invalid path name */
#define E_CONTROL_C         0x89    /* job cancelled via a control-C */
#define E_CONTROL           0x8a    /* invalid control */
#define E_UNMATCHED_LISTS   0x8b
#define E_INVALID_DATE      0x8c
#define E_NO_PARAMETERS     0x8d    /* no parameters found in command line */
#define E_VERSION           0x8e    /* version of entered command
									   incompatible with system */
#define E_GET_PATH_ORDER    0x8f    /* get$output$pathname called before
									   get$input$pathname */
#define E_PERMISSION        0x90    /* do not have proper access */
#define E_INVALID_TIME      0x91    /* setting of time was invalid */

/*
 * RMX UDI environmental errors
 */
    
#define E_UNKNOWN_EXIT      0xc0    /* normal termination */
#define E_WARNING_EXIT      0xc1    /* warning termination */
#define E_ERROR_EXIT        0xc2    /* error termination */
#define E_FATAL_EXIT        0xc3    /* fatal error termination */
#define E_ABORT_EXIT        0xc4    /* user program aborted */
#define E_UDI_INTERNAL      0xc5    /* unrecoverable internal error */
                                         
/*
 * iRMX Nucleus programming errors
 */
    
#define E_ZERO_DIVIDE           0x8000
#define E_OVERFLOW              0x8001    /* overflow interrupt occured */
#define E_TYPE                  0x8002    /* token parameter is of invalid
											 type */
#define EBOUNDS                 0x8003    /* 16-bit address (offset)
                                           * is above 64 Kb */
#define E_PARAM                 0x8004    /* parameter has an invalid value */
#define E_BAD_CALL              0x8005    /* An OS extension received an
											 invalid code */
#define E_ARRAY_BOUNDS          0x8006    /* array overflow*/
#define E_NDP_ERROR             0x8007    /* NPX error has occured */
#define E_ILLEGAL_OPCODE        0x8008
#define E_EMULATOR_TRAP         0x8009    /* an ESC instruction was encountered
											 with emulator bit set in MSW */
#define E_CHECK_EXCEPTION       0x800a    /* a PASCAL task exceeded CASE
                                             statement boundary */    
#define E_CPU_XFER_DATA_LIMIT   0x800b    /* the NPX tried to access an address
											 that is out of segment bound */
#define E_PROTECTION            0x800d    /* General Protection error */
#define E_NOT_PRESENT           0x800e    /* A request to load a segment register
											 whose segment is not present */
#define E_BAD_ADDR              0x800f    /* Invalid logical address */

/*
 * iRMX Nucleus Communication Service programming errors
 */
    
#define E_PROTOCOL              0x80e0    /* port parameter is wrong protocol */
#define E_PORT_ID_USED          0x80e1    /* request port id is in use */
#define E_NUC_BAD_BUF           0x80e2    /* invalid buffer pointer or 
                                             insufficient buffer length */

/*
 * iRMX BIOS and EIOS programming errors
 */
    
#define E_NOUSER                0x8021    /* no default user is define d */
#define E_NOPREFIX              0x8022    /* no default prefix is define d */
#define E_BAD_BUFF              0x8023    /* specified buffer too small for
											 requested operation */
#define E_NOT_LOG_NAME          0x8040    /* the specified object is not a
											 device or file connection */
#define E_NOT_DEVICE            0x8041    /* the specified object is not a
											 device connection */
#define E_NOT_CONNECTION        0x8042    /* the specified object is not a file
											 connection */
                                         
/*
 * iRMX AL programming errors
 */
     
#define E_JOB_PARAM             0x8060    /* maximum memory specified is less
											 than the minimum memory specified */
                                         
/*
 * iRMX HI programming errors
 */
    
#define E_PARSE_TABLES          0x8080    /* internal error in parse tables */
#define E_JOB_TABLES            0x8081    /* internal inconsistency in job
											 tables */
#define E_DEFAULT_SO            0x8083    /* default output name string specified
											 is invalid */
#define E_STRING                0x8084    /* Returned pathname exceeds 255
											 characters in length */
#define E_ERROR_OUTPUT          0x8085    /* send$eo$response called when command
											 connection allows only
                                             send$co$response */
                                         
/*
 * iRMX UDI programming errors
 */
     
#define E_RESERVE_PARAM         0x80c6    /* calling program attempted to reserve
											 more than 12 files or buffers */
#define E_OPEN_PARAM            0x80c7    /* calling program attempted to open a
											 file with more than two buffers */

#endif /* _RMX_ERR */
