#ifndef MEMBLOCK_H
#define MEMBLOCK_H

/* 
 * Memblocks are chains of 64-byte blocks of data, i.e. blatantly
 * optimized to deal w/ the way we get data from the ethernet
 * devices. Vaguely inspired by mbufs, but again, blatantly optimized
 * for the available platform.
 */

#include "types.h"

typedef struct tag_memblock memblock;

struct tag_memblock {
  u8 data[64];
  memblock *next;
};


memblock *new_memblock(void);
memblock *copy_to_new_memblock(void *data);
void free_memblock_chain(memblock *mb);

#endif /* MEMBLOCK_H */
