#ifndef _SOCKSTREAM_H
#define _SOCKSTREAM_H

#include <fstream.h>

class sockstream {
    // abstract: A sockstream contains the input and output streams 
    //           connected to a socket.
public:
    sockstream(int sock) : in_(sock), out_(sock){}
    // effects  Returns a new sockstream connected to the given descriptor.

    ifstream& in() {return in_;}
    // effects  Returns the input stream.

    ofstream& out() {return out_;} 
    // effects  Returns the input stream.
    sockstream (const sockstream  &s):
	in_(s.in_), out_ (s.out_)
    {}
    
    void close() {in_.close(); out_.close();}
    // modifies "this"
    // effects  Closes the input and output streams

private: 
    // disabled
    sockstream();
    operator=(sockstream &);

    ifstream in_;  // the input stream
    ofstream out_; // the output stream
};

#endif /* _SOCKSTREAM_H */
