# Copyright (c) 1995 by the Student Information Processing Board
# 	  of the Massachusetts Institute of Technology
#  
# Permission to use, copy, modify, and distribute this software
# and its documentation for any purpose and without fee is
# hereby granted, provided that the above copyright notice
# appear in all copies and that both that copyright notice and
# this permission notice appear in supporting documentation,
# and that the names of M.I.T. and the M.I.T. S.I.P.B. not be
# used in advertising or publicity pertaining to distribution
# of the software without specific, written prior permission.
# M.I.T. and the M.I.T. S.I.P.B. make no representations about
# the suitability of this software for any purpose.  It is
# provided "as is" without express or implied warranty.
#
#	$Id: config.sh,v 1.20 1996/06/01 18:36:43 ghudson Exp $
#	$Source: /afs/sipb/project/sipb-athena/src/install/arch/i386_nbsd1/RCS/config.sh,v $

# /tmp/vars inputs:
#	disk		disk device containing NetBSD partition
#	u1letter	letter of /u1 subpartition
#	u1cachesize	megabytes for cache if located in /u1 partition.
#	host		unqualified hostname of this system
#	domain		domain name of this system
#	intf		network interface device
#	ifaddr		IP address of network interface
#	ifnetmask	netmask of network interface
#	ifbcast		broadcast address of network interface
#	ifflags		flags of network interface
#	ifgateway	gateway address of subnet
#	rootpw		encrypted root password
#	enable_toor	whether to enable the toor account
#	rootmail	where to forward root mail

. /tmp/vars

echo -n "Creating configuration files... "
cat > /hd/etc/fstab << EOM
/dev/${disk}a / ufs rw 1 1
/dev/${disk}${u1letter} /u1 ufs rw 1 1
EOM
if [ "$u1letter" = f ]; then
	echo "/dev/${disk}e /u1/usr/vice/cache ufs rw 1 1" >> /hd/etc/fstab
fi
cat >> /hd/etc/fstab << EOM
procfs /proc procfs rw 1 2
kernfs /kern kernfs rw 1 1
EOM

echo $host > /hd/etc/myname
echo	"127.0.0.1	localhost localhost.$domain" > /hd/etc/hosts
echo "$ifaddr	$host.$domain $host" >> /hd/etc/hosts
echo "$ifgateway" > /hd/etc/mygate
echo "inet $host.$domain $ifnetmask $ifbcast $ifflags" \
	> /hd/etc/hostname.$intf
sync
echo "done."

echo -n "Setting root password... "
ed -s /hd/etc/master.passwd << EOM
/^root/s:root\::root\:${rootpw}:
w
q
EOM
if [ "$enable_toor" = "yes" ]; then
	ed -s /hd/etc/master.passwd << EOM
/^toor/s:toor\:\*:toor\:${rootpw}:
w
q
EOM
fi
echo "done."
chroot /hd pwd_mkdb -p /etc/master.passwd

echo -n "Setting up root mail forwarding... "
if [ -n "$rootmail" ]; then
	ed -s /hd/etc/aliases << EOS
/root:/c
root: $rootmail
.
w
q
EOS
else
	ed -s /hd/etc/aliases << EOS
/root:/c
# root:
.
w
q
EOS
fi
echo "done."
chroot /hd newaliases

echo "Creating /etc/group.local from /etc/group."
cp /etc/group /etc/group.local

echo "Changing root's shell to /bin/athena/tcsh."
chroot /hd /usr/bin/chsh -s /bin/athena/tcsh root 2> /dev/null

size=`df -k | grep /hd/u1/usr/vice/cache | awk '{print $4}'`
if [ -n "$size" ]; then
	size=`expr $size \* 8 / 10`
else
	size="$u1cachesize"
fi
echo "Making $size kilobyte cache in /usr/vice/cache."
echo "/afs:/usr/vice/cache:${size}" > /hd/usr/vice/etc/cacheinfo

echo "Creating /etc/noremote to disallow unauthorized remote logins."
touch /hd/etc/noremote

sync
